/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.interceptor;

import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.framework.AbstractSingletonProxyFactoryBean;
import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.PlatformTransactionManager;
import cn.taketoday.transaction.interceptor.TransactionAttributeSource;
import cn.taketoday.transaction.interceptor.TransactionAttributeSourceAdvisor;
import cn.taketoday.transaction.interceptor.TransactionInterceptor;
import cn.taketoday.transaction.interceptor.TransactionalProxy;
import java.util.Properties;
import org.aopalliance.aop.Advice;

public class TransactionProxyFactoryBean
extends AbstractSingletonProxyFactoryBean
implements BeanFactoryAware {
    private static final long serialVersionUID = 1L;
    private final TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
    @Nullable
    private Pointcut pointcut;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionInterceptor.setTransactionManager(transactionManager);
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        this.transactionInterceptor.setTransactionAttributes(transactionAttributes);
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionInterceptor.setTransactionAttributeSource(transactionAttributeSource);
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.transactionInterceptor.setBeanFactory(beanFactory);
    }

    protected Object createMainInterceptor() {
        this.transactionInterceptor.afterPropertiesSet();
        if (this.pointcut != null) {
            return new DefaultPointcutAdvisor(this.pointcut, (Advice)this.transactionInterceptor);
        }
        return new TransactionAttributeSourceAdvisor(this.transactionInterceptor);
    }

    protected void postProcessProxyFactory(ProxyFactory proxyFactory) {
        proxyFactory.addInterface(TransactionalProxy.class);
    }
}

