/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.jta;

import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationUtils;
import jakarta.transaction.Synchronization;
import java.util.List;

public class JtaAfterCompletionSynchronization
implements Synchronization {
    private final List<TransactionSynchronization> synchronizations;

    public JtaAfterCompletionSynchronization(List<TransactionSynchronization> synchronizations) {
        this.synchronizations = synchronizations;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        switch (status) {
            case 3: {
                try {
                    TransactionSynchronizationUtils.invokeAfterCommit(this.synchronizations);
                    break;
                }
                finally {
                    TransactionSynchronizationUtils.invokeAfterCompletion(this.synchronizations, 0);
                }
            }
            case 4: {
                TransactionSynchronizationUtils.invokeAfterCompletion(this.synchronizations, 1);
                break;
            }
            default: {
                TransactionSynchronizationUtils.invokeAfterCompletion(this.synchronizations, 2);
            }
        }
    }
}

