/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.jta;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.jta.UserTransactionAdapter;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import jakarta.transaction.Synchronization;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;

public class JtaSynchronizationAdapter
implements Synchronization {
    protected static final Logger logger = LoggerFactory.getLogger(JtaSynchronizationAdapter.class);
    private final TransactionSynchronization frameworkSynchronization;
    @Nullable
    private UserTransaction jtaTransaction;
    private boolean beforeCompletionCalled = false;

    public JtaSynchronizationAdapter(TransactionSynchronization frameworkSynchronization) {
        Assert.notNull((Object)frameworkSynchronization, (String)"TransactionSynchronization must not be null");
        this.frameworkSynchronization = frameworkSynchronization;
    }

    public JtaSynchronizationAdapter(TransactionSynchronization frameworkSynchronization, @Nullable UserTransaction jtaUserTransaction) {
        this(frameworkSynchronization);
        this.jtaTransaction = jtaUserTransaction;
    }

    public JtaSynchronizationAdapter(TransactionSynchronization frameworkSynchronization, @Nullable TransactionManager jtaTransactionManager) {
        this(frameworkSynchronization);
        this.jtaTransaction = new UserTransactionAdapter(jtaTransactionManager);
    }

    public void beforeCompletion() {
        try {
            boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            this.frameworkSynchronization.beforeCommit(readOnly);
        }
        catch (Error | RuntimeException ex) {
            this.setRollbackOnlyIfPossible();
            throw ex;
        }
        finally {
            this.beforeCompletionCalled = true;
            this.frameworkSynchronization.beforeCompletion();
        }
    }

    private void setRollbackOnlyIfPossible() {
        if (this.jtaTransaction != null) {
            try {
                this.jtaTransaction.setRollbackOnly();
            }
            catch (UnsupportedOperationException ex) {
                logger.debug("JTA transaction handle does not support setRollbackOnly method - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.error("Could not set JTA transaction rollback-only", ex);
            }
        } else {
            logger.debug("No JTA transaction handle available and/or running on WebLogic - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion");
        }
    }

    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.frameworkSynchronization.beforeCompletion();
        }
        switch (status) {
            case 3: {
                this.frameworkSynchronization.afterCompletion(0);
                break;
            }
            case 4: {
                this.frameworkSynchronization.afterCompletion(1);
                break;
            }
            default: {
                this.frameworkSynchronization.afterCompletion(2);
            }
        }
    }
}

