/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.jta;

import cn.taketoday.transaction.TransactionSystemException;
import cn.taketoday.transaction.support.SmartTransactionObject;
import cn.taketoday.transaction.support.TransactionSynchronizationUtils;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;

public class JtaTransactionObject
implements SmartTransactionObject {
    private final UserTransaction userTransaction;
    boolean resetTransactionTimeout = false;

    public JtaTransactionObject(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public final UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    @Override
    public boolean isRollbackOnly() {
        try {
            int jtaStatus = this.userTransaction.getStatus();
            return jtaStatus == 1 || jtaStatus == 4;
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on getStatus", ex);
        }
    }

    @Override
    public void flush() {
        TransactionSynchronizationUtils.triggerFlush();
    }
}

