/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.reactive;

import cn.taketoday.transaction.NoTransactionException;
import cn.taketoday.transaction.reactive.TransactionContext;
import java.util.Deque;

final class TransactionContextHolder {
    private final Deque<TransactionContext> transactionStack;

    TransactionContextHolder(Deque<TransactionContext> transactionStack) {
        this.transactionStack = transactionStack;
    }

    TransactionContext currentContext() {
        TransactionContext context = this.transactionStack.peek();
        if (context == null) {
            throw new NoTransactionException("No transaction in context");
        }
        return context;
    }

    TransactionContext createContext() {
        TransactionContext context = this.transactionStack.peek();
        context = context != null ? new TransactionContext(context) : new TransactionContext();
        this.transactionStack.push(context);
        return context;
    }

    boolean hasContext() {
        return !this.transactionStack.isEmpty();
    }
}

