/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.reactive;

import cn.taketoday.aop.scope.ScopedObject;
import cn.taketoday.core.InfrastructureProxy;
import cn.taketoday.lang.Assert;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.reactive.TransactionSynchronization;
import cn.taketoday.util.ClassUtils;
import java.util.Collection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class TransactionSynchronizationUtils {
    private static final Logger logger = LoggerFactory.getLogger(TransactionSynchronizationUtils.class);
    private static final boolean aopAvailable = ClassUtils.isPresent((String)"cn.taketoday.aop.scope.ScopedObject", (ClassLoader)TransactionSynchronizationUtils.class.getClassLoader());

    TransactionSynchronizationUtils() {
    }

    static Object unwrapResourceIfNecessary(Object resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        Object resourceRef = resource;
        if (resourceRef instanceof InfrastructureProxy) {
            resourceRef = ((InfrastructureProxy)resourceRef).getWrappedObject();
        }
        if (aopAvailable) {
            resourceRef = ScopedProxyUnwrapper.unwrapIfNecessary(resourceRef);
        }
        return resourceRef;
    }

    public static Mono<Void> triggerBeforeCommit(Collection<TransactionSynchronization> synchronizations, boolean readOnly) {
        return Flux.fromIterable(synchronizations).concatMap(it -> it.beforeCommit(readOnly)).then();
    }

    public static Mono<Void> triggerBeforeCompletion(Collection<TransactionSynchronization> synchronizations) {
        return Flux.fromIterable(synchronizations).concatMap(TransactionSynchronization::beforeCompletion).onErrorContinue((t, o) -> logger.error("TransactionSynchronization.beforeCompletion threw exception", t)).then();
    }

    public static Mono<Void> invokeAfterCommit(Collection<TransactionSynchronization> synchronizations) {
        return Flux.fromIterable(synchronizations).concatMap(TransactionSynchronization::afterCommit).then();
    }

    public static Mono<Void> invokeAfterCompletion(Collection<TransactionSynchronization> synchronizations, int completionStatus) {
        return Flux.fromIterable(synchronizations).concatMap(it -> it.afterCompletion(completionStatus)).onErrorContinue((t, o) -> logger.error("TransactionSynchronization.afterCompletion threw exception", t)).then();
    }

    private static class ScopedProxyUnwrapper {
        private ScopedProxyUnwrapper() {
        }

        public static Object unwrapIfNecessary(Object resource) {
            if (resource instanceof ScopedObject) {
                return ((ScopedObject)resource).getTargetObject();
            }
            return resource;
        }
    }
}

