/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.reactive;

import cn.taketoday.transaction.ReactiveTransactionManager;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import cn.taketoday.transaction.reactive.TransactionCallback;
import cn.taketoday.transaction.reactive.TransactionalOperatorImpl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface TransactionalOperator {
    default public <T> Flux<T> transactional(Flux<T> flux) {
        return this.execute(it -> flux);
    }

    default public <T> Mono<T> transactional(Mono<T> mono) {
        return this.execute(it -> mono).singleOrEmpty();
    }

    public <T> Flux<T> execute(TransactionCallback<T> var1) throws TransactionException;

    public static TransactionalOperator create(ReactiveTransactionManager transactionManager) {
        return TransactionalOperator.create(transactionManager, TransactionDefinition.withDefaults());
    }

    public static TransactionalOperator create(ReactiveTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        return new TransactionalOperatorImpl(transactionManager, transactionDefinition);
    }
}

