/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.reactive;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.ReactiveTransaction;
import cn.taketoday.transaction.ReactiveTransactionManager;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import cn.taketoday.transaction.TransactionSystemException;
import cn.taketoday.transaction.reactive.TransactionCallback;
import cn.taketoday.transaction.reactive.TransactionContextManager;
import cn.taketoday.transaction.reactive.TransactionalOperator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class TransactionalOperatorImpl
implements TransactionalOperator {
    private static final Logger log = LoggerFactory.getLogger(TransactionalOperatorImpl.class);
    private final ReactiveTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition;

    TransactionalOperatorImpl(ReactiveTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        Assert.notNull((Object)transactionManager, (String)"ReactiveTransactionManager must not be null");
        Assert.notNull((Object)transactionDefinition, (String)"TransactionDefinition must not be null");
        this.transactionManager = transactionManager;
        this.transactionDefinition = transactionDefinition;
    }

    public ReactiveTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public <T> Flux<T> execute(TransactionCallback<T> action) throws TransactionException {
        return TransactionContextManager.currentContext().flatMapMany(context -> Flux.usingWhen(this.transactionManager.getReactiveTransaction(this.transactionDefinition), action::doInTransaction, this.transactionManager::commit, this::rollbackOnException, this.transactionManager::rollback).onErrorMap(this::unwrapIfResourceCleanupFailure)).contextWrite(TransactionContextManager.getOrCreateContext()).contextWrite(TransactionContextManager.getOrCreateContextHolder());
    }

    private Mono<Void> rollbackOnException(ReactiveTransaction status, Throwable ex) throws TransactionException {
        log.debug("Initiating transaction rollback on application exception", ex);
        return this.transactionManager.rollback(status).onErrorMap(ex2 -> {
            log.error("Application exception overridden by rollback exception", ex);
            if (ex2 instanceof TransactionSystemException) {
                TransactionSystemException tse = (TransactionSystemException)((Object)((Object)ex2));
                tse.initApplicationException(ex);
            } else {
                ex2.addSuppressed(ex);
            }
            return ex2;
        });
    }

    private Throwable unwrapIfResourceCleanupFailure(Throwable ex) {
        String msg;
        if (ex instanceof RuntimeException && ex.getCause() != null && (msg = ex.getMessage()) != null && msg.startsWith("Async resource cleanup failed")) {
            return ex.getCause();
        }
        return ex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!super.equals(other)) return false;
        if (!(other instanceof TransactionalOperatorImpl)) return true;
        TransactionalOperatorImpl toi = (TransactionalOperatorImpl)other;
        if (this.getTransactionManager() != toi.getTransactionManager()) return false;
        return true;
    }

    public int hashCode() {
        return this.getTransactionManager().hashCode();
    }
}

