/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.support;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.ConfigurableTransactionManager;
import cn.taketoday.transaction.IllegalTransactionStateException;
import cn.taketoday.transaction.InvalidTimeoutException;
import cn.taketoday.transaction.NestedTransactionNotSupportedException;
import cn.taketoday.transaction.PlatformTransactionManager;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import cn.taketoday.transaction.TransactionExecutionListener;
import cn.taketoday.transaction.TransactionStatus;
import cn.taketoday.transaction.TransactionSuspensionNotSupportedException;
import cn.taketoday.transaction.UnexpectedRollbackException;
import cn.taketoday.transaction.support.DefaultTransactionDefinition;
import cn.taketoday.transaction.support.DefaultTransactionStatus;
import cn.taketoday.transaction.support.SynchronizationInfo;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import cn.taketoday.transaction.support.TransactionSynchronizationUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractPlatformTransactionManager
implements PlatformTransactionManager,
ConfigurableTransactionManager,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SYNCHRONIZATION_ALWAYS = 0;
    public static final int SYNCHRONIZATION_ON_ACTUAL_TRANSACTION = 1;
    public static final int SYNCHRONIZATION_NEVER = 2;
    static final Map<String, Integer> constants = Map.of("SYNCHRONIZATION_ALWAYS", 0, "SYNCHRONIZATION_ON_ACTUAL_TRANSACTION", 1, "SYNCHRONIZATION_NEVER", 2);
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private int transactionSynchronization = 0;
    private int defaultTimeout = -1;
    private boolean nestedTransactionAllowed = false;
    private boolean validateExistingTransaction = false;
    private boolean globalRollbackOnParticipationFailure = true;
    private boolean failEarlyOnGlobalRollbackOnly = false;
    private boolean rollbackOnCommitFailure = false;
    private Collection<TransactionExecutionListener> transactionExecutionListeners = new ArrayList<TransactionExecutionListener>();

    public final void setTransactionSynchronizationName(String constantName) {
        Assert.hasText((String)constantName, (String)"'constantName' must not be null or blank");
        Integer transactionSynchronization = constants.get(constantName);
        Assert.notNull((Object)transactionSynchronization, (String)"Only transaction synchronization constants allowed");
        this.transactionSynchronization = transactionSynchronization;
    }

    public final void setTransactionSynchronization(int transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    public final int getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    public final void setDefaultTimeout(int defaultTimeout) {
        if (defaultTimeout < -1) {
            throw new InvalidTimeoutException("Invalid default timeout", defaultTimeout);
        }
        this.defaultTimeout = defaultTimeout;
    }

    public final int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public final void setNestedTransactionAllowed(boolean nestedTransactionAllowed) {
        this.nestedTransactionAllowed = nestedTransactionAllowed;
    }

    public final boolean isNestedTransactionAllowed() {
        return this.nestedTransactionAllowed;
    }

    public final void setValidateExistingTransaction(boolean validateExistingTransaction) {
        this.validateExistingTransaction = validateExistingTransaction;
    }

    public final boolean isValidateExistingTransaction() {
        return this.validateExistingTransaction;
    }

    public final void setGlobalRollbackOnParticipationFailure(boolean globalRollbackOnParticipationFailure) {
        this.globalRollbackOnParticipationFailure = globalRollbackOnParticipationFailure;
    }

    public final boolean isGlobalRollbackOnParticipationFailure() {
        return this.globalRollbackOnParticipationFailure;
    }

    public final void setFailEarlyOnGlobalRollbackOnly(boolean failEarlyOnGlobalRollbackOnly) {
        this.failEarlyOnGlobalRollbackOnly = failEarlyOnGlobalRollbackOnly;
    }

    public final boolean isFailEarlyOnGlobalRollbackOnly() {
        return this.failEarlyOnGlobalRollbackOnly;
    }

    public final void setRollbackOnCommitFailure(boolean rollbackOnCommitFailure) {
        this.rollbackOnCommitFailure = rollbackOnCommitFailure;
    }

    public final boolean isRollbackOnCommitFailure() {
        return this.rollbackOnCommitFailure;
    }

    @Override
    public final void setTransactionExecutionListeners(Collection<TransactionExecutionListener> listeners) {
        this.transactionExecutionListeners = listeners;
    }

    @Override
    public final Collection<TransactionExecutionListener> getTransactionExecutionListeners() {
        return this.transactionExecutionListeners;
    }

    @Override
    public final TransactionStatus getTransaction(@Nullable TransactionDefinition definition) throws TransactionException {
        TransactionDefinition def = definition != null ? definition : TransactionDefinition.withDefaults();
        Object transaction = this.doGetTransaction();
        if (this.isExistingTransaction(transaction)) {
            return this.handleExistingTransaction(def, transaction);
        }
        if (def.getTimeout() < -1) {
            throw new InvalidTimeoutException("Invalid transaction timeout", def.getTimeout());
        }
        switch (def.getPropagationBehavior()) {
            case 2: {
                throw new IllegalTransactionStateException("No existing transaction found for transaction marked with propagation 'mandatory'");
            }
            case 0: 
            case 3: 
            case 6: {
                SuspendedResourcesHolder suspendedResources = this.suspend(null);
                boolean debugEnabled = this.logger.isDebugEnabled();
                if (debugEnabled) {
                    this.logger.debug("Creating new transaction with name [{}]: ", (Object)def, (Object)def.getName());
                }
                try {
                    return this.startTransaction(def, transaction, false, debugEnabled, suspendedResources);
                }
                catch (Error | RuntimeException ex) {
                    this.resume(null, suspendedResources);
                    throw ex;
                }
            }
        }
        if (def.getIsolationLevel() != -1 && this.logger.isWarnEnabled()) {
            this.logger.warn("Custom isolation level specified but no actual transaction initiated; isolation level will effectively be ignored: {}", (Object)def);
        }
        boolean newSynchronization = this.getTransactionSynchronization() == 0;
        return this.prepareTransactionStatus(def, null, true, newSynchronization, this.logger.isDebugEnabled(), null);
    }

    private TransactionStatus handleExistingTransaction(TransactionDefinition definition, Object transaction) throws TransactionException {
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (definition.getPropagationBehavior() == 5) {
            throw new IllegalTransactionStateException("Existing transaction found for transaction marked with propagation 'never'");
        }
        if (definition.getPropagationBehavior() == 4) {
            if (debugEnabled) {
                this.logger.debug("Suspending current transaction");
            }
            SuspendedResourcesHolder suspendedResources = this.suspend(transaction);
            boolean newSynchronization = this.getTransactionSynchronization() == 0;
            return this.prepareTransactionStatus(definition, null, false, newSynchronization, debugEnabled, suspendedResources);
        }
        if (definition.getPropagationBehavior() == 3) {
            if (debugEnabled) {
                this.logger.debug("Suspending current transaction, creating new transaction with name [{}]", (Object)definition.getName());
            }
            SuspendedResourcesHolder suspendedResources = this.suspend(transaction);
            try {
                return this.startTransaction(definition, transaction, false, debugEnabled, suspendedResources);
            }
            catch (Error | RuntimeException beginEx) {
                this.resumeAfterBeginException(transaction, suspendedResources, beginEx);
                throw beginEx;
            }
        }
        if (definition.getPropagationBehavior() == 6) {
            if (!this.isNestedTransactionAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions by default - specify 'nestedTransactionAllowed' property with value 'true'");
            }
            if (debugEnabled) {
                this.logger.debug("Creating nested transaction with name [{}]", (Object)definition.getName());
            }
            if (this.useSavepointForNestedTransaction()) {
                DefaultTransactionStatus status = this.newTransactionStatus(definition, transaction, false, false, true, debugEnabled, null);
                this.transactionExecutionListeners.forEach(listener -> listener.beforeBegin(status));
                try {
                    status.createAndHoldSavepoint();
                }
                catch (Error | RuntimeException ex) {
                    this.transactionExecutionListeners.forEach(listener -> listener.afterBegin(status, ex));
                    throw ex;
                }
                this.transactionExecutionListeners.forEach(listener -> listener.afterBegin(status, null));
                return status;
            }
            return this.startTransaction(definition, transaction, true, debugEnabled, null);
        }
        if (debugEnabled) {
            this.logger.debug("Participating in existing transaction");
        }
        if (this.isValidateExistingTransaction()) {
            Integer currentIsolationLevel;
            if (definition.getIsolationLevel() != -1 && ((currentIsolationLevel = TransactionSynchronizationManager.getCurrentTransactionIsolationLevel()) == null || currentIsolationLevel.intValue() != definition.getIsolationLevel())) {
                throw new IllegalTransactionStateException("Participating transaction with definition [" + definition + "] specifies isolation level which is incompatible with existing transaction: " + (currentIsolationLevel != null ? DefaultTransactionDefinition.getIsolationLevelName(currentIsolationLevel) : "(unknown)"));
            }
            if (!definition.isReadOnly() && TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                throw new IllegalTransactionStateException("Participating transaction with definition [" + definition + "] is not marked as read-only but existing transaction is");
            }
        }
        boolean newSynchronization = this.getTransactionSynchronization() != 2;
        return this.prepareTransactionStatus(definition, transaction, false, newSynchronization, debugEnabled, null);
    }

    private TransactionStatus startTransaction(TransactionDefinition definition, Object transaction, boolean nested, boolean debugEnabled, @Nullable SuspendedResourcesHolder suspendedResources) {
        boolean newSynchronization = this.getTransactionSynchronization() != 2;
        DefaultTransactionStatus status = this.newTransactionStatus(definition, transaction, true, newSynchronization, nested, debugEnabled, suspendedResources);
        this.transactionExecutionListeners.forEach(listener -> listener.beforeBegin(status));
        try {
            this.doBegin(transaction, definition);
        }
        catch (Error | RuntimeException ex) {
            this.transactionExecutionListeners.forEach(listener -> listener.afterBegin(status, ex));
            throw ex;
        }
        this.prepareSynchronization(status, definition);
        this.transactionExecutionListeners.forEach(listener -> listener.afterBegin(status, null));
        return status;
    }

    private DefaultTransactionStatus prepareTransactionStatus(TransactionDefinition definition, @Nullable Object transaction, boolean newTransaction, boolean newSynchronization, boolean debug, @Nullable Object suspendedResources) {
        DefaultTransactionStatus status = this.newTransactionStatus(definition, transaction, newTransaction, newSynchronization, false, debug, suspendedResources);
        this.prepareSynchronization(status, definition);
        return status;
    }

    private DefaultTransactionStatus newTransactionStatus(TransactionDefinition definition, @Nullable Object transaction, boolean newTransaction, boolean newSynchronization, boolean nested, boolean debug, @Nullable Object suspendedResources) {
        boolean actualNewSynchronization = newSynchronization && !TransactionSynchronizationManager.isSynchronizationActive();
        return new DefaultTransactionStatus(definition.getName(), transaction, newTransaction, actualNewSynchronization, nested, definition.isReadOnly(), debug, suspendedResources);
    }

    private void prepareSynchronization(DefaultTransactionStatus status, TransactionDefinition definition) {
        if (status.isNewSynchronization()) {
            SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
            info.setActualTransactionActive(status.hasTransaction());
            info.setCurrentTransactionIsolationLevel(definition.getIsolationLevel() != -1 ? Integer.valueOf(definition.getIsolationLevel()) : null);
            info.setCurrentTransactionReadOnly(definition.isReadOnly());
            info.setCurrentTransactionName(definition.getName());
            info.initSynchronization();
        }
    }

    protected int determineTimeout(TransactionDefinition definition) {
        if (definition.getTimeout() != -1) {
            return definition.getTimeout();
        }
        return this.getDefaultTimeout();
    }

    @Nullable
    protected final SuspendedResourcesHolder suspend(@Nullable Object transaction) throws TransactionException {
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        if (info.isSynchronizationActive()) {
            List<TransactionSynchronization> suspendedSynchronizations = this.doSuspendSynchronization(info);
            try {
                Object suspendedResources = null;
                if (transaction != null) {
                    suspendedResources = this.doSuspend(transaction);
                }
                String name = info.getCurrentTransactionName();
                info.setCurrentTransactionName(null);
                boolean readOnly = info.isCurrentTransactionReadOnly();
                info.setCurrentTransactionReadOnly(false);
                Integer isolationLevel = info.getCurrentTransactionIsolationLevel();
                info.setCurrentTransactionIsolationLevel(null);
                boolean wasActive = info.isActualTransactionActive();
                info.setActualTransactionActive(false);
                return new SuspendedResourcesHolder(suspendedResources, suspendedSynchronizations, name, readOnly, isolationLevel, wasActive);
            }
            catch (Error | RuntimeException ex) {
                this.doResumeSynchronization(suspendedSynchronizations);
                throw ex;
            }
        }
        if (transaction != null) {
            Object suspendedResources = this.doSuspend(transaction);
            return new SuspendedResourcesHolder(suspendedResources);
        }
        return null;
    }

    protected final void resume(@Nullable Object transaction, @Nullable SuspendedResourcesHolder resourcesHolder) throws TransactionException {
        if (resourcesHolder != null) {
            List<TransactionSynchronization> suspendedSynchronizations;
            Object suspendedResources = resourcesHolder.suspendedResources;
            if (suspendedResources != null) {
                this.doResume(transaction, suspendedResources);
            }
            if ((suspendedSynchronizations = resourcesHolder.suspendedSynchronizations) != null) {
                SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
                info.setActualTransactionActive(resourcesHolder.wasActive);
                info.setCurrentTransactionIsolationLevel(resourcesHolder.isolationLevel);
                info.setCurrentTransactionReadOnly(resourcesHolder.readOnly);
                info.setCurrentTransactionName(resourcesHolder.name);
                this.doResumeSynchronization(suspendedSynchronizations);
            }
        }
    }

    private void resumeAfterBeginException(Object transaction, @Nullable SuspendedResourcesHolder suspendedResources, Throwable beginEx) {
        try {
            this.resume(transaction, suspendedResources);
        }
        catch (Error | RuntimeException resumeEx) {
            String exMessage = "Inner transaction begin exception overridden by outer transaction resume exception";
            this.logger.error(exMessage, beginEx);
            throw resumeEx;
        }
    }

    private List<TransactionSynchronization> doSuspendSynchronization(SynchronizationInfo info) {
        List<TransactionSynchronization> suspendedSynchronizations = info.getSynchronizations();
        for (TransactionSynchronization synchronization : suspendedSynchronizations) {
            synchronization.suspend();
        }
        info.clearSynchronization();
        return suspendedSynchronizations;
    }

    private void doResumeSynchronization(List<TransactionSynchronization> suspendedSynchronizations) {
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        info.initSynchronization();
        for (TransactionSynchronization synchronization : suspendedSynchronizations) {
            synchronization.resume();
            info.registerSynchronization(synchronization);
        }
    }

    @Override
    public final void commit(TransactionStatus status) throws TransactionException {
        if (status.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        if (defStatus.isLocalRollbackOnly()) {
            if (defStatus.isDebug()) {
                this.logger.debug("Transactional code has requested rollback");
            }
            this.processRollback(defStatus, false);
            return;
        }
        if (!this.shouldCommitOnGlobalRollbackOnly() && defStatus.isGlobalRollbackOnly()) {
            if (defStatus.isDebug()) {
                this.logger.debug("Global transaction is marked as rollback-only but transactional code requested commit");
            }
            this.processRollback(defStatus, true);
            return;
        }
        this.processCommit(defStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommit(DefaultTransactionStatus status) throws TransactionException {
        try {
            boolean beforeCompletionInvoked = false;
            boolean commitListenerInvoked = false;
            try {
                boolean unexpectedRollback = false;
                this.prepareForCommit(status);
                this.triggerBeforeCommit(status);
                this.triggerBeforeCompletion(status);
                beforeCompletionInvoked = true;
                if (status.hasSavepoint()) {
                    if (status.isDebug()) {
                        this.logger.debug("Releasing transaction savepoint");
                    }
                    unexpectedRollback = status.isGlobalRollbackOnly();
                    this.transactionExecutionListeners.forEach(listener -> listener.beforeCommit(status));
                    commitListenerInvoked = true;
                    status.releaseHeldSavepoint();
                } else if (status.isNewTransaction()) {
                    if (status.isDebug()) {
                        this.logger.debug("Initiating transaction commit");
                    }
                    unexpectedRollback = status.isGlobalRollbackOnly();
                    this.transactionExecutionListeners.forEach(listener -> listener.beforeCommit(status));
                    commitListenerInvoked = true;
                    this.doCommit(status);
                } else if (this.isFailEarlyOnGlobalRollbackOnly()) {
                    unexpectedRollback = status.isGlobalRollbackOnly();
                }
                if (unexpectedRollback) {
                    throw new UnexpectedRollbackException("Transaction silently rolled back because it has been marked as rollback-only");
                }
            }
            catch (UnexpectedRollbackException ex) {
                this.triggerAfterCompletion(status, 1);
                this.transactionExecutionListeners.forEach(listener -> listener.afterRollback(status, null));
                throw ex;
            }
            catch (TransactionException ex) {
                if (this.isRollbackOnCommitFailure()) {
                    this.doRollbackOnCommitException(status, (Throwable)((Object)ex));
                } else {
                    this.triggerAfterCompletion(status, 2);
                    if (commitListenerInvoked) {
                        this.transactionExecutionListeners.forEach(listener -> listener.afterCommit(status, (Throwable)((Object)ex)));
                    }
                }
                throw ex;
            }
            catch (Error | RuntimeException ex) {
                if (!beforeCompletionInvoked) {
                    this.triggerBeforeCompletion(status);
                }
                this.doRollbackOnCommitException(status, ex);
                throw ex;
            }
            try {
                this.triggerAfterCommit(status);
            }
            finally {
                this.triggerAfterCompletion(status, 0);
                if (commitListenerInvoked) {
                    this.transactionExecutionListeners.forEach(listener -> listener.afterCommit(status, null));
                }
            }
        }
        finally {
            this.cleanupAfterCompletion(status);
        }
    }

    @Override
    public final void rollback(TransactionStatus status) throws TransactionException {
        if (status.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        this.processRollback(defStatus, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRollback(DefaultTransactionStatus status, boolean unexpected) {
        try {
            boolean unexpectedRollback = unexpected;
            boolean rollbackListenerInvoked = false;
            try {
                this.triggerBeforeCompletion(status);
                if (status.hasSavepoint()) {
                    if (status.isDebug()) {
                        this.logger.debug("Rolling back transaction to savepoint");
                    }
                    this.transactionExecutionListeners.forEach(listener -> listener.beforeRollback(status));
                    rollbackListenerInvoked = true;
                    status.rollbackToHeldSavepoint();
                } else if (status.isNewTransaction()) {
                    if (status.isDebug()) {
                        this.logger.debug("Initiating transaction rollback");
                    }
                    this.transactionExecutionListeners.forEach(listener -> listener.beforeRollback(status));
                    rollbackListenerInvoked = true;
                    this.doRollback(status);
                } else {
                    if (status.hasTransaction()) {
                        if (status.isLocalRollbackOnly() || this.isGlobalRollbackOnParticipationFailure()) {
                            if (status.isDebug()) {
                                this.logger.debug("Participating transaction failed - marking existing transaction as rollback-only");
                            }
                            this.doSetRollbackOnly(status);
                        } else if (status.isDebug()) {
                            this.logger.debug("Participating transaction failed - letting transaction originator decide on rollback");
                        }
                    } else {
                        this.logger.debug("Should roll back transaction but cannot - no transaction available");
                    }
                    if (!this.isFailEarlyOnGlobalRollbackOnly()) {
                        unexpectedRollback = false;
                    }
                }
            }
            catch (Error | RuntimeException ex) {
                this.triggerAfterCompletion(status, 2);
                if (rollbackListenerInvoked) {
                    this.transactionExecutionListeners.forEach(listener -> listener.afterRollback(status, ex));
                }
                throw ex;
            }
            this.triggerAfterCompletion(status, 1);
            if (rollbackListenerInvoked) {
                this.transactionExecutionListeners.forEach(listener -> listener.afterRollback(status, null));
            }
            if (unexpectedRollback) {
                throw new UnexpectedRollbackException("Transaction rolled back because it has been marked as rollback-only");
            }
        }
        finally {
            this.cleanupAfterCompletion(status);
        }
    }

    private void doRollbackOnCommitException(DefaultTransactionStatus status, Throwable ex) throws TransactionException {
        try {
            if (status.isNewTransaction()) {
                if (status.isDebug()) {
                    this.logger.debug("Initiating transaction rollback after commit exception", ex);
                }
                this.doRollback(status);
            } else if (status.hasTransaction() && this.isGlobalRollbackOnParticipationFailure()) {
                if (status.isDebug()) {
                    this.logger.debug("Marking existing transaction as rollback-only after commit exception", ex);
                }
                this.doSetRollbackOnly(status);
            }
        }
        catch (Error | RuntimeException rbex) {
            this.logger.error("Commit exception overridden by rollback exception", ex);
            this.triggerAfterCompletion(status, 2);
            this.transactionExecutionListeners.forEach(listener -> listener.afterRollback(status, rbex));
            throw rbex;
        }
        this.triggerAfterCompletion(status, 1);
        this.transactionExecutionListeners.forEach(listener -> listener.afterRollback(status, null));
    }

    protected final void triggerBeforeCommit(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            TransactionSynchronizationUtils.triggerBeforeCommit(status.isReadOnly());
        }
    }

    protected final void triggerBeforeCompletion(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            TransactionSynchronizationUtils.triggerBeforeCompletion();
        }
    }

    private void triggerAfterCommit(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            TransactionSynchronizationUtils.triggerAfterCommit();
        }
    }

    private void triggerAfterCompletion(DefaultTransactionStatus status, int completionStatus) {
        if (status.isNewSynchronization()) {
            SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
            List<TransactionSynchronization> synchronizations = info.getSynchronizations();
            info.clearSynchronization();
            if (!status.hasTransaction() || status.isNewTransaction()) {
                this.invokeAfterCompletion(synchronizations, completionStatus);
            } else if (!synchronizations.isEmpty()) {
                this.registerAfterCompletionWithExistingTransaction(status.getTransaction(), synchronizations);
            }
        }
    }

    protected final void invokeAfterCompletion(List<TransactionSynchronization> synchronizations, int completionStatus) {
        TransactionSynchronizationUtils.invokeAfterCompletion(synchronizations, completionStatus);
    }

    private void cleanupAfterCompletion(DefaultTransactionStatus status) {
        status.setCompleted();
        if (status.isNewSynchronization()) {
            TransactionSynchronizationManager.clear();
        }
        if (status.isNewTransaction()) {
            this.doCleanupAfterCompletion(status.getTransaction());
        }
        if (status.getSuspendedResources() != null) {
            if (status.isDebug()) {
                this.logger.debug("Resuming suspended transaction after completion of inner transaction");
            }
            Object transaction = status.hasTransaction() ? status.getTransaction() : null;
            this.resume(transaction, (SuspendedResourcesHolder)status.getSuspendedResources());
        }
    }

    protected abstract Object doGetTransaction() throws TransactionException;

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return false;
    }

    protected boolean useSavepointForNestedTransaction() {
        return true;
    }

    protected abstract void doBegin(Object var1, TransactionDefinition var2) throws TransactionException;

    protected Object doSuspend(Object transaction) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return false;
    }

    protected void prepareForCommit(DefaultTransactionStatus status) {
    }

    protected abstract void doCommit(DefaultTransactionStatus var1) throws TransactionException;

    protected abstract void doRollback(DefaultTransactionStatus var1) throws TransactionException;

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        throw new IllegalTransactionStateException("Participating in existing transactions is not supported - when 'isExistingTransaction' returns true, appropriate 'doSetRollbackOnly' behavior must be provided");
    }

    protected void registerAfterCompletionWithExistingTransaction(Object transaction, List<TransactionSynchronization> synchronizations) throws TransactionException {
        this.logger.debug("Cannot register Framework after-completion synchronization with existing transaction - processing Framework after-completion callbacks immediately, with outcome status 'unknown'");
        this.invokeAfterCompletion(synchronizations, 2);
    }

    protected void doCleanupAfterCompletion(Object transaction) {
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    protected static final class SuspendedResourcesHolder {
        @Nullable
        public final Object suspendedResources;
        @Nullable
        public List<TransactionSynchronization> suspendedSynchronizations;
        @Nullable
        public String name;
        public boolean readOnly;
        @Nullable
        public Integer isolationLevel;
        public boolean wasActive;

        private SuspendedResourcesHolder(Object suspendedResources) {
            this.suspendedResources = suspendedResources;
        }

        private SuspendedResourcesHolder(@Nullable Object suspendedResources, List<TransactionSynchronization> suspendedSynchronizations, @Nullable String name, boolean readOnly, @Nullable Integer isolationLevel, boolean wasActive) {
            this.suspendedResources = suspendedResources;
            this.suspendedSynchronizations = suspendedSynchronizations;
            this.name = name;
            this.readOnly = readOnly;
            this.isolationLevel = isolationLevel;
            this.wasActive = wasActive;
        }
    }
}

