/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.support;

import cn.taketoday.beans.factory.config.Scope;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.support.SynchronizationInfo;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class SimpleTransactionScope
implements Scope {
    public Object get(String name, Supplier<?> objectFactory) {
        Object scopedObject;
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)info.getResource(this);
        if (scopedObjects == null) {
            scopedObjects = new ScopedObjectsHolder();
            info.registerSynchronization(new CleanupSynchronization(scopedObjects));
            info.bindResource(this, scopedObjects);
        }
        if ((scopedObject = scopedObjects.scopedInstances.get(name)) == null) {
            scopedObject = objectFactory.get();
            scopedObjects.scopedInstances.put(name, scopedObject);
        }
        return scopedObject;
    }

    @Nullable
    public Object remove(String name) {
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects != null) {
            scopedObjects.destructionCallbacks.remove(name);
            return scopedObjects.scopedInstances.remove(name);
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects != null) {
            scopedObjects.destructionCallbacks.put(name, callback);
        }
    }

    @Nullable
    public Object resolveContextualObject(String key) {
        return null;
    }

    @Nullable
    public String getConversationId() {
        return TransactionSynchronizationManager.getCurrentTransactionName();
    }

    static class ScopedObjectsHolder {
        final Map<String, Object> scopedInstances = new HashMap<String, Object>();
        final Map<String, Runnable> destructionCallbacks = new LinkedHashMap<String, Runnable>();

        ScopedObjectsHolder() {
        }
    }

    private class CleanupSynchronization
    implements TransactionSynchronization {
        private final ScopedObjectsHolder scopedObjects;

        public CleanupSynchronization(ScopedObjectsHolder scopedObjects) {
            this.scopedObjects = scopedObjects;
        }

        @Override
        public void suspend() {
            TransactionSynchronizationManager.unbindResource(SimpleTransactionScope.this);
        }

        @Override
        public void resume() {
            TransactionSynchronizationManager.bindResource(SimpleTransactionScope.this, this.scopedObjects);
        }

        @Override
        public void afterCompletion(int status) {
            TransactionSynchronizationManager.unbindResourceIfPossible(SimpleTransactionScope.this);
            for (Runnable callback : this.scopedObjects.destructionCallbacks.values()) {
                callback.run();
            }
            this.scopedObjects.destructionCallbacks.clear();
            this.scopedObjects.scopedInstances.clear();
        }
    }
}

