/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.support;

import cn.taketoday.core.OrderComparator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.support.ResourceHolder;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationUtils;
import cn.taketoday.util.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SynchronizationInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SynchronizationInfo.class);
    private static final long serialVersionUID = 1L;
    @Nullable
    private String currentTransactionName;
    @Nullable
    private Boolean actualTransactionActive;
    @Nullable
    private Boolean currentTransactionReadOnly;
    @Nullable
    private Integer currentTransactionIsolationLevel;
    @Nullable
    private transient Map<Object, Object> resourceMap;
    @Nullable
    private transient LinkedHashSet<TransactionSynchronization> synchronizations;

    public Map<Object, Object> getResourceMap() {
        return this.resourceMap != null ? Collections.unmodifiableMap(this.resourceMap) : Collections.emptyMap();
    }

    public boolean hasResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        return this.doGetResource(actualKey) != null;
    }

    @Nullable
    public <T> T getResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = this.doGetResource(actualKey);
        if (value != null && log.isTraceEnabled()) {
            log.trace("Retrieved value [{}] for key [{}] bound to thread: [{}]", new Object[]{value, key, Thread.currentThread().getName()});
        }
        return (T)value;
    }

    @Nullable
    private Object doGetResource(Object actualKey) {
        if (this.resourceMap == null) {
            return null;
        }
        Object value = this.resourceMap.get(actualKey);
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            this.resourceMap.remove(actualKey);
            if (this.resourceMap.isEmpty()) {
                this.resourceMap = null;
            }
            value = null;
        }
        return value;
    }

    public void bindResource(Object key, Object value) throws IllegalStateException {
        Object oldValue;
        Assert.notNull((Object)value, (String)"Value must not be null");
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Map<Object, Object> map = this.resourceMap;
        if (map == null) {
            this.resourceMap = map = new HashMap<Object, Object>(8);
        }
        if ((oldValue = map.put(actualKey, value)) instanceof ResourceHolder && ((ResourceHolder)oldValue).isVoid()) {
            oldValue = null;
        }
        if (oldValue != null) {
            throw new IllegalStateException("Already value [" + oldValue + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
    }

    public Object unbindResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = this.doUnbindResource(actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread");
        }
        return value;
    }

    @Nullable
    public Object unbindResourceIfPossible(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        return this.doUnbindResource(actualKey);
    }

    @Nullable
    private Object doUnbindResource(Object key) {
        Map<Object, Object> map = this.resourceMap;
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        Object value = map.remove(key);
        if (map.isEmpty()) {
            this.resourceMap = null;
        }
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            value = null;
        }
        return value;
    }

    public boolean isSynchronizationActive() {
        return this.synchronizations != null;
    }

    public void initSynchronization() {
        if (this.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        if (log.isDebugEnabled()) {
            log.debug("Initializing transaction synchronization");
        }
        this.synchronizations = new LinkedHashSet(8);
    }

    public void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        Assert.notNull((Object)synchronization, (String)"TransactionSynchronization must not be null");
        if (this.synchronizations == null) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        this.synchronizations.add(synchronization);
    }

    public void clearSynchronization() throws IllegalStateException {
        if (this.isSynchronizationActive()) {
            if (log.isDebugEnabled()) {
                log.debug("Clearing transaction synchronization");
            }
        } else {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        this.synchronizations = null;
    }

    public List<TransactionSynchronization> getSynchronizations() {
        LinkedHashSet<TransactionSynchronization> synchs = this.synchronizations;
        if (synchs == null) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        if (synchs.isEmpty()) {
            return Collections.emptyList();
        }
        if (synchs.size() == 1) {
            return Collections.singletonList((TransactionSynchronization)synchs.iterator().next());
        }
        ArrayList<TransactionSynchronization> sortedSynchs = new ArrayList<TransactionSynchronization>(synchs);
        OrderComparator.sort(sortedSynchs);
        return Collections.unmodifiableList(sortedSynchs);
    }

    @Nullable
    public String getCurrentTransactionName() {
        return this.currentTransactionName;
    }

    public void setCurrentTransactionName(@Nullable String name) {
        this.currentTransactionName = name;
    }

    public boolean isCurrentTransactionReadOnly() {
        return this.currentTransactionReadOnly != null;
    }

    public void setCurrentTransactionReadOnly(Boolean readOnly) {
        this.currentTransactionReadOnly = readOnly != false ? Boolean.TRUE : null;
    }

    @Nullable
    public Integer getCurrentTransactionIsolationLevel() {
        return this.currentTransactionIsolationLevel;
    }

    public void setCurrentTransactionIsolationLevel(@Nullable Integer isolationLevel) {
        this.currentTransactionIsolationLevel = isolationLevel;
    }

    public boolean isActualTransactionActive() {
        return this.actualTransactionActive != null;
    }

    public void setActualTransactionActive(boolean active) {
        this.actualTransactionActive = active ? Boolean.TRUE : null;
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug("Clear the entire transaction synchronization state for the current thread");
        }
        this.synchronizations = null;
        this.currentTransactionName = null;
        this.actualTransactionActive = null;
        this.currentTransactionReadOnly = null;
        this.currentTransactionIsolationLevel = null;
    }

    public void triggerFlush() {
        for (TransactionSynchronization synchronization : this.getSynchronizations()) {
            synchronization.flush();
        }
    }

    public void triggerBeforeCommit(boolean readOnly) {
        for (TransactionSynchronization synchronization : this.getSynchronizations()) {
            synchronization.beforeCommit(readOnly);
        }
    }

    public void triggerBeforeCompletion() {
        for (TransactionSynchronization synchronization : this.getSynchronizations()) {
            try {
                synchronization.beforeCompletion();
            }
            catch (Throwable tsex) {
                log.error("TransactionSynchronization.beforeCompletion threw exception", tsex);
            }
        }
    }

    public void triggerAfterCommit() {
        for (TransactionSynchronization synchronization : this.getSynchronizations()) {
            synchronization.afterCommit();
        }
    }

    public void triggerAfterCompletion(int completionStatus) {
        for (TransactionSynchronization synchronization : this.getSynchronizations()) {
            try {
                synchronization.afterCompletion(completionStatus);
            }
            catch (Throwable tsex) {
                log.error("TransactionSynchronization.afterCompletion threw exception", tsex);
            }
        }
    }

    public void invokeAfterCompletion(@Nullable List<TransactionSynchronization> syncs, int completionStatus) {
        if (syncs != null) {
            for (TransactionSynchronization synchronization : syncs) {
                try {
                    synchronization.afterCompletion(completionStatus);
                }
                catch (Throwable tsex) {
                    log.error("TransactionSynchronization.afterCompletion threw exception", tsex);
                }
            }
        }
    }
}

