/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.support;

import cn.taketoday.core.NamedThreadLocal;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.support.SynchronizationInfo;
import cn.taketoday.transaction.support.TransactionSynchronization;
import java.util.List;
import java.util.Map;

public abstract class TransactionSynchronizationManager {
    private static final NamedThreadLocal<SynchronizationInfo> META_DATA = NamedThreadLocal.withInitial((String)"Current Synchronization Info", SynchronizationInfo::new);

    public static SynchronizationInfo getSynchronizationInfo() {
        return (SynchronizationInfo)META_DATA.get();
    }

    public static Map<Object, Object> getResourceMap() {
        return TransactionSynchronizationManager.getSynchronizationInfo().getResourceMap();
    }

    public static boolean hasResource(Object key) {
        return TransactionSynchronizationManager.getSynchronizationInfo().hasResource(key);
    }

    @Nullable
    public static <T> T getResource(Object key) {
        return TransactionSynchronizationManager.getSynchronizationInfo().getResource(key);
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        TransactionSynchronizationManager.getSynchronizationInfo().bindResource(key, value);
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        return TransactionSynchronizationManager.getSynchronizationInfo().unbindResource(key);
    }

    @Nullable
    public static Object unbindResourceIfPossible(Object key) {
        return TransactionSynchronizationManager.getSynchronizationInfo().unbindResourceIfPossible(key);
    }

    public static boolean isSynchronizationActive() {
        return TransactionSynchronizationManager.getSynchronizationInfo().isSynchronizationActive();
    }

    public static void initSynchronization() throws IllegalStateException {
        TransactionSynchronizationManager.getSynchronizationInfo().initSynchronization();
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        TransactionSynchronizationManager.getSynchronizationInfo().registerSynchronization(synchronization);
    }

    public static List<TransactionSynchronization> getSynchronizations() throws IllegalStateException {
        return TransactionSynchronizationManager.getSynchronizationInfo().getSynchronizations();
    }

    public static void clearSynchronization() throws IllegalStateException {
        TransactionSynchronizationManager.getSynchronizationInfo().clearSynchronization();
    }

    public static void setCurrentTransactionName(@Nullable String name) {
        TransactionSynchronizationManager.getSynchronizationInfo().setCurrentTransactionName(name);
    }

    @Nullable
    public static String getCurrentTransactionName() {
        return TransactionSynchronizationManager.getSynchronizationInfo().getCurrentTransactionName();
    }

    public static void setCurrentTransactionReadOnly(boolean readOnly) {
        TransactionSynchronizationManager.getSynchronizationInfo().setCurrentTransactionReadOnly(readOnly);
    }

    public static boolean isCurrentTransactionReadOnly() {
        return TransactionSynchronizationManager.getSynchronizationInfo().isCurrentTransactionReadOnly();
    }

    public static void setCurrentTransactionIsolationLevel(@Nullable Integer isolationLevel) {
        TransactionSynchronizationManager.getSynchronizationInfo().setCurrentTransactionIsolationLevel(isolationLevel);
    }

    @Nullable
    public static Integer getCurrentTransactionIsolationLevel() {
        return TransactionSynchronizationManager.getSynchronizationInfo().getCurrentTransactionIsolationLevel();
    }

    public static void setActualTransactionActive(boolean active) {
        TransactionSynchronizationManager.getSynchronizationInfo().setActualTransactionActive(active);
    }

    public static boolean isActualTransactionActive() {
        return TransactionSynchronizationManager.getSynchronizationInfo().isActualTransactionActive();
    }

    public static void clear() {
        TransactionSynchronizationManager.getSynchronizationInfo().clear();
    }
}

