/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.support;

import cn.taketoday.aop.scope.ScopedObject;
import cn.taketoday.core.InfrastructureProxy;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.support.ResourceTransactionManager;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import cn.taketoday.util.ClassUtils;
import java.util.List;

public abstract class TransactionSynchronizationUtils {
    private static final Logger log = LoggerFactory.getLogger(TransactionSynchronizationUtils.class);
    private static final boolean aopAvailable = ClassUtils.isPresent((String)"cn.taketoday.aop.scope.ScopedObject", (ClassLoader)TransactionSynchronizationUtils.class.getClassLoader());

    public static boolean sameResourceFactory(ResourceTransactionManager tm, Object resourceFactory) {
        return TransactionSynchronizationUtils.unwrapResourceIfNecessary(tm.getResourceFactory()).equals(TransactionSynchronizationUtils.unwrapResourceIfNecessary(resourceFactory));
    }

    public static Object unwrapResourceIfNecessary(Object resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        Object resourceRef = resource;
        if (resourceRef instanceof InfrastructureProxy) {
            resourceRef = ((InfrastructureProxy)resourceRef).getWrappedObject();
        }
        if (aopAvailable) {
            resourceRef = ScopedProxyUnwrapper.unwrapIfNecessary(resourceRef);
        }
        return resourceRef;
    }

    public static void triggerFlush() {
        for (TransactionSynchronization synchronization : TransactionSynchronizationManager.getSynchronizations()) {
            synchronization.flush();
        }
    }

    public static void triggerBeforeCommit(boolean readOnly) {
        for (TransactionSynchronization synchronization : TransactionSynchronizationManager.getSynchronizations()) {
            synchronization.beforeCommit(readOnly);
        }
    }

    public static void triggerBeforeCompletion() {
        for (TransactionSynchronization synchronization : TransactionSynchronizationManager.getSynchronizations()) {
            try {
                synchronization.beforeCompletion();
            }
            catch (Throwable ex) {
                log.error("TransactionSynchronization.beforeCompletion threw exception", ex);
            }
        }
    }

    public static void triggerAfterCommit() {
        TransactionSynchronizationUtils.invokeAfterCommit(TransactionSynchronizationManager.getSynchronizations());
    }

    public static void invokeAfterCommit(@Nullable List<TransactionSynchronization> synchronizations) {
        if (synchronizations != null) {
            for (TransactionSynchronization synchronization : synchronizations) {
                synchronization.afterCommit();
            }
        }
    }

    public static void triggerAfterCompletion(int completionStatus) {
        List<TransactionSynchronization> synchronizations = TransactionSynchronizationManager.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCompletion(synchronizations, completionStatus);
    }

    public static void invokeAfterCompletion(@Nullable List<TransactionSynchronization> synchronizations, int completionStatus) {
        if (synchronizations != null) {
            for (TransactionSynchronization synchronization : synchronizations) {
                try {
                    synchronization.afterCompletion(completionStatus);
                }
                catch (Throwable ex) {
                    log.error("TransactionSynchronization.afterCompletion threw exception", ex);
                }
            }
        }
    }

    private static class ScopedProxyUnwrapper {
        private ScopedProxyUnwrapper() {
        }

        public static Object unwrapIfNecessary(Object resource) {
            if (resource instanceof ScopedObject) {
                return ((ScopedObject)resource).getTargetObject();
            }
            return resource;
        }
    }
}

