/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.support;

import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.PlatformTransactionManager;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import cn.taketoday.transaction.TransactionStatus;
import cn.taketoday.transaction.TransactionSystemException;
import cn.taketoday.transaction.support.CallbackPreferringPlatformTransactionManager;
import cn.taketoday.transaction.support.DefaultTransactionDefinition;
import cn.taketoday.transaction.support.TransactionCallback;
import cn.taketoday.transaction.support.TransactionOperations;
import java.lang.reflect.UndeclaredThrowableException;

public class TransactionTemplate
extends DefaultTransactionDefinition
implements TransactionOperations,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TransactionTemplate.class);
    @Nullable
    private PlatformTransactionManager transactionManager;

    public TransactionTemplate() {
    }

    public TransactionTemplate(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionTemplate(PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        super(transactionDefinition);
        this.transactionManager = transactionManager;
    }

    public void setTransactionManager(@Nullable PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Nullable
    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void afterPropertiesSet() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("Property 'transactionManager' is required");
        }
    }

    @Override
    @Nullable
    public <T> T execute(TransactionCallback<T> action) throws TransactionException {
        T result;
        PlatformTransactionManager transactionManager = this.getTransactionManager();
        Assert.state((transactionManager != null ? 1 : 0) != 0, (String)"No PlatformTransactionManager set");
        if (transactionManager instanceof CallbackPreferringPlatformTransactionManager) {
            return ((CallbackPreferringPlatformTransactionManager)transactionManager).execute(this, action);
        }
        TransactionStatus status = transactionManager.getTransaction(this);
        try {
            result = action.doInTransaction(status);
        }
        catch (Error | RuntimeException ex) {
            this.rollbackOnException(transactionManager, status, ex);
            throw ex;
        }
        catch (Throwable ex) {
            this.rollbackOnException(transactionManager, status, ex);
            throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
        }
        transactionManager.commit(status);
        return result;
    }

    private void rollbackOnException(PlatformTransactionManager transactionManager, TransactionStatus status, Throwable ex) throws TransactionException {
        log.debug("Initiating transaction rollback on application exception", ex);
        try {
            transactionManager.rollback(status);
        }
        catch (TransactionSystemException ex2) {
            log.error("Application exception overridden by rollback exception", ex);
            ex2.initApplicationException(ex);
            throw ex2;
        }
        catch (Error | RuntimeException ex2) {
            log.error("Application exception overridden by rollback exception", ex);
            throw ex2;
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || super.equals(other) && (!(other instanceof TransactionTemplate) || this.getTransactionManager() == ((TransactionTemplate)other).getTransactionManager());
    }
}

