package cn.takujo.common_api.framework_config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;

/**
 * 阿里druid数据源配置， 继承后添加Configuration注解
 * 
 * @author wzx
 *
 */
public abstract class DruidConfig {

	@ConfigurationProperties(prefix = "spring.datasource")
	@Bean
	public DataSource druid() {
		return new DruidDataSource();
	}

	@Bean
	public ServletRegistrationBean<Servlet> statViewServlet() {
		ServletRegistrationBean<Servlet> bean = new ServletRegistrationBean<>(new StatViewServlet(), "/druid/*");
		Map<String, String> map = new HashMap<>();
		map.put("loginUsername", loginUsername());
		map.put("loginPassword", loginPassword());
		map.put("allow", "");// 默认允许所有访问
		bean.setInitParameters(map);
		return bean;
	}

	@Bean
	public FilterRegistrationBean<Filter> webStatFilter() {
		FilterRegistrationBean<Filter> bean = new FilterRegistrationBean<>();
		bean.setFilter(new WebStatFilter());
		Map<String, String> map = new HashMap<>();
		map.put("exclusions", "*. js ,*. gif ,*. jpg ,*. png ,*. css ,*. ico ,/druid/*");
		bean.setInitParameters(map);
		bean.setUrlPatterns(Arrays.asList("/*"));
		return bean;
	}

	/**
	 * 设置druid控制台登录名
	 * 
	 * @return 登录名
	 */
	protected abstract String loginUsername();

	/**
	 * 设置druid控制台登录密码
	 * 
	 * @return 登录密码
	 */
	protected abstract String loginPassword();

}
