/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static void saveFile(MultipartFile file, File save) {
        BufferedOutputStream stream = null;
        if (!file.isEmpty()) {
            try {
                byte[] bytes = file.getBytes();
                log.info("save file: " + save.getAbsolutePath());
                stream = new BufferedOutputStream(new FileOutputStream(save));
                stream.write(bytes);
                stream.close();
            }
            catch (Exception e) {
                stream = null;
            }
            log.info("upload: success");
        } else {
            log.warn("upload: failure");
        }
    }

    public static void deleteFiles(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fs;
                for (File f : fs = file.listFiles()) {
                    FileUtil.deleteFiles(f);
                }
                boolean result = file.delete();
                log.info("delete directory: " + file.getName() + " " + result);
            } else if (file.isFile()) {
                boolean result = file.delete();
                log.info("delete file: " + file.getAbsolutePath() + " " + result);
            }
        }
    }
}

