/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;

public final class QrcoderUtil {
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public static final int RED = 0xFF0000;
    public static final int YELLOW = 0xFFFF00;
    public static final int BLUE = 255;
    public static final int PURPLE = 0x800080;
    public static final int GREEN = 32768;

    public static void generate(String content, int width, int height, String outPutPath) throws Exception {
        HashMap<EncodeHintType, String> his = new HashMap<EncodeHintType, String>();
        his.put(EncodeHintType.CHARACTER_SET, "utf-8");
        try {
            BitMatrix encode = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, his);
            int codeWidth = encode.getWidth();
            int codeHeight = encode.getHeight();
            BufferedImage image = new BufferedImage(codeWidth, codeHeight, 1);
            for (int i = 0; i < codeWidth; ++i) {
                for (int j = 0; j < codeHeight; ++j) {
                    image.setRGB(i, j, encode.get(i, j) ? 0 : 0xFFFFFF);
                }
            }
            File outPutImage = new File(outPutPath);
            String fileName = outPutImage.getName();
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            outPutImage.getParentFile().mkdirs();
            if (!outPutImage.exists()) {
                outPutImage.createNewFile();
            }
            ImageIO.write((RenderedImage)image, extension, outPutImage);
        }
        catch (WriterException e) {
            throw new Exception("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25");
        }
        catch (IOException e) {
            throw new Exception("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25");
        }
        catch (Exception e) {
            throw new Exception("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25");
        }
    }

    public static void generate(String content, int width, int height, String outPutPath, int frontColor, int backColor) throws Exception {
        HashMap<EncodeHintType, String> his = new HashMap<EncodeHintType, String>();
        his.put(EncodeHintType.CHARACTER_SET, "utf-8");
        try {
            BitMatrix encode = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, his);
            int codeWidth = encode.getWidth();
            int codeHeight = encode.getHeight();
            BufferedImage image = new BufferedImage(codeWidth, codeHeight, 1);
            for (int i = 0; i < codeWidth; ++i) {
                for (int j = 0; j < codeHeight; ++j) {
                    image.setRGB(i, j, encode.get(i, j) ? frontColor : backColor);
                }
            }
            File outPutImage = new File(outPutPath);
            String fileName = outPutImage.getName();
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            outPutImage.getParentFile().mkdirs();
            if (!outPutImage.exists()) {
                outPutImage.createNewFile();
            }
            ImageIO.write((RenderedImage)image, extension, outPutImage);
        }
        catch (WriterException e) {
            throw new Exception("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25");
        }
        catch (IOException e) {
            throw new Exception("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25");
        }
        catch (Exception e) {
            throw new Exception("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25");
        }
    }

    public static String analyze(String codePath) throws Exception {
        File file = new File(codePath);
        if (!file.exists()) {
            throw new Exception("\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728,\u65e0\u6cd5\u89e3\u6790");
        }
        try {
            BufferedImage image = ImageIO.read(file);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
            MultiFormatReader formatReader = new MultiFormatReader();
            Result result = formatReader.decode(binaryBitmap, hints);
            return result.getText();
        }
        catch (NotFoundException e) {
            throw new Exception("\u89e3\u6790\u5931\u8d25");
        }
        catch (IOException e) {
            throw new Exception("\u89e3\u6790\u5931\u8d25");
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u5931\u8d25");
        }
    }
}

