package cn.takujo.common_api.util;

import net.sourceforge.pinyin4j.PinyinHelper;

/**
 * 中文转换为拼音
 * 
 * @author wzx
 *
 */
public final class PinyinUtil {

	/**
	 * 转换为拼音
	 * 
	 * @param chinese
	 *            中文字符（会过滤掉非中文字符）
	 * @return 拼音
	 */
	public static String toPinYin(String chinese) {
		StringBuffer sb = new StringBuffer("");
		char[] array = chinese.toCharArray();
		for (char c : array) {
			String[] ss = PinyinHelper.toHanyuPinyinStringArray(c);
			if (ss != null) {
				sb.append(ss[0].substring(0, ss[0].length() - 1));
			}
		}
		return sb.toString();
	}

}
