/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import cn.takujo.common_api.exception.AESException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class AESUtil {
    private static final String CHARSET = "UTF-8";
    private static final String KEY_AES = "AES";

    public static String encrypt(String data, String key) throws AESException {
        return AESUtil.doAES(data, key, 1);
    }

    public static String decrypt(String data, String key) throws AESException {
        return AESUtil.doAES(data, key, 2);
    }

    private static String doAES(String data, String key, int mode) throws AESException {
        if ("".equals(data) || "".equals(key)) {
            throw new AESException("aes03", "key\u6216data\u4e3a\u7a7a");
        }
        try {
            boolean encrypt = mode == 1;
            byte[] content = encrypt ? data.getBytes(CHARSET) : AESUtil.parseHexStr2Byte(data);
            KeyGenerator kgen = KeyGenerator.getInstance(KEY_AES);
            kgen.init(128, new SecureRandom(key.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, KEY_AES);
            Cipher cipher = Cipher.getInstance(KEY_AES);
            cipher.init(mode, keySpec);
            byte[] result = cipher.doFinal(content);
            if (encrypt) {
                return AESUtil.parseByte2HexStr(result);
            }
            return new String(result, CHARSET);
        }
        catch (InvalidKeyException e) {
            throw new AESException("aes01", "\u65e0\u6548\u7684key");
        }
        catch (UnsupportedEncodingException e) {
            throw new AESException("aes01", "\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AESException("aes01", "\u65e0\u5339\u914d\u7684\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            throw new AESException("aes01", "\u65e0\u5339\u914d\u586b\u5145");
        }
        catch (IllegalBlockSizeException e) {
            throw new AESException("aes01", "\u975e\u6cd5\u7684\u5757\u5927\u5c0f");
        }
        catch (BadPaddingException e) {
            throw new AESException("aes02", "\u89e3\u5bc6\u5931\u8d25");
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

