/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LoggerBuilder {
    private static final Map<String, Logger> CONTAINER = new HashMap<String, Logger>();
    private static final Level LEVEL = Level.INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logger logger = CONTAINER.get(name);
        if (logger != null) {
            return logger;
        }
        Class<LoggerBuilder> clazz = LoggerBuilder.class;
        synchronized (LoggerBuilder.class) {
            logger = CONTAINER.get(name);
            if (logger != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return logger;
            }
            logger = LoggerBuilder.build(name);
            CONTAINER.put(name, logger);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return logger;
        }
    }

    private static Logger build(String name) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger(name);
        logger.setAdditive(false);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %-5level %logger{50} - %msg%n");
        encoder.start();
        ConsoleAppender console = new ConsoleAppender();
        console.setContext((Context)context);
        console.setEncoder((Encoder)encoder);
        console.start();
        logger.addAppender((Appender)console);
        logger.setLevel(LEVEL);
        return logger;
    }
}

