/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import cn.takujo.common_api.exception.OssException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class OssUtil {
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;

    public void uploadFile(String objectName, InputStream input) throws OssException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            if (ossClient.doesBucketExist(this.bucketName)) {
                ossClient.putObject(this.bucketName, objectName, input);
            }
        }
        catch (OSSException e) {
            e.printStackTrace();
            throw new OssException("oss01", "\u4e0a\u4f20\u5230OSS->\u5931\u8d25");
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new OssException("oss01", "\u4e0a\u4f20\u5230OSS->\u5931\u8d25");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public void uploadFile(String objectName, File file) throws OssException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            if (ossClient.doesBucketExist(this.bucketName)) {
                ossClient.putObject(this.bucketName, objectName, file);
            }
        }
        catch (OSSException e) {
            e.printStackTrace();
            throw new OssException("oss02", "\u4e0a\u4f20\u5230OSS->\u5931\u8d25");
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new OssException("oss02", "\u4e0a\u4f20\u5230OSS->\u5931\u8d25");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public List<String> deleteDirectory(String directory) throws OssException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            if (ossClient.doesBucketExist(this.bucketName)) {
                ObjectListing objectListing = ossClient.listObjects(this.bucketName, directory + "/");
                List objectSummary = objectListing.getObjectSummaries();
                ArrayList<String> keys = new ArrayList<String>();
                for (OSSObjectSummary object : objectSummary) {
                    keys.add(object.getKey());
                }
                DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(this.bucketName).withKeys(keys));
                List list = deleteObjectsResult.getDeletedObjects();
                return list;
            }
            ArrayList<String> objectListing = new ArrayList<String>();
            return objectListing;
        }
        catch (OSSException e) {
            e.printStackTrace();
            throw new OssException("oss03", "OSS\u4e0a\u5220\u9664\u76ee\u5f55\u5931\u8d25");
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new OssException("oss03", "OSS\u4e0a\u5220\u9664\u76ee\u5f55\u5931\u8d25");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public void deleteFile(String file) throws OssException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            if (ossClient.doesBucketExist(this.bucketName)) {
                ossClient.deleteObject(this.bucketName, file);
            }
        }
        catch (OSSException e) {
            e.printStackTrace();
            throw new OssException("oss04", "OSS\u4e0a\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25");
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new OssException("oss04", "OSS\u4e0a\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public String url(String objectName, long validityPeriod) throws OssException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            Date expiration = new Date(new Date().getTime() + validityPeriod * 1000L);
            return ossClient.generatePresignedUrl(this.bucketName, objectName, expiration).toString();
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new OssException("oss05", "OSS\u751f\u6210url\u5931\u8d25");
        }
    }

    public OssUtil(String endpoint, String accessKeyId, String accessKeySecret, String bucketName) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.bucketName = bucketName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssUtil)) {
            return false;
        }
        OssUtil other = (OssUtil)o;
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        return !(this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        return result;
    }

    public String toString() {
        return "OssUtil(endpoint=" + this.getEndpoint() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", bucketName=" + this.getBucketName() + ")";
    }
}

