package cn.takujo.common_api.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.springframework.web.multipart.MultipartFile;

import lombok.extern.slf4j.Slf4j;

/**
 * File工具
 * 
 * @author wzx
 *
 */
@Slf4j
public final class FileUtil {

	public static void saveFile(MultipartFile file, File save) {
		BufferedOutputStream stream = null;
		if (!file.isEmpty()) {
			try {
				log.info("save file: " + save.getAbsolutePath());
				byte[] bytes = file.getBytes();
				stream = new BufferedOutputStream(new FileOutputStream(save));
				stream.write(bytes);
				log.info("upload: success");
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				log.warn("upload: failure -> file not found");
			} catch (IOException e) {
				e.printStackTrace();
				log.warn("upload: failure -> stream write failure");
			} finally {
				if (stream != null) {
					try {
						stream.close();
					} catch (IOException e) {
						e.printStackTrace();
						log.warn("upload: error -> stream close failure");
					}
				}
				stream = null;
			}
		} else {
			log.warn("upload: failure ->file is Empty");
		}
	}

	public static void deleteFiles(File file) {
		if (file.exists()) {
			if (file.isDirectory()) {
				File[] fs = file.listFiles();
				for (File f : fs) {
					deleteFiles(f);
				}
				boolean result = file.delete();
				log.info("delete directory: " + file.getName() + " " + result);
			} else if (file.isFile()) {
				boolean result = file.delete();
				log.info("delete file: " + file.getAbsolutePath() + " " + result);
			}
		}
	}

}
