package cn.takujo.common_api.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;

/**
 * xml工具
 * 
 * @author wzx
 *
 */
public class XmlUtil {

	/**
	 * 会忽略最外层的xml标签
	 * 
	 * @param xml
	 *            xml
	 * @return map
	 * @throws JsonParseException
	 *             异常
	 * @throws JsonMappingException
	 *             异常
	 * @throws IOException
	 *             异常
	 */
	public static Map<String, ?> xmlToMap(String xml) throws JsonParseException, JsonMappingException, IOException {
		XmlMapper xmlMapper = new XmlMapper();
		MapType mapType = xmlMapper.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
		return xmlMapper.readValue(xml, mapType);
	}

	/**
	 * 会在最外层套上xml标签作为根标签
	 * 
	 * @param map
	 *            参数集
	 * @return 字符串形式的xml
	 * @throws IOException
	 *             异常
	 */
	public static String mapToXml(Map<String, ?> map) throws IOException {
		XmlMapper xmlMapper = new XmlMapper();
		return xmlMapper.writeValueAsString(map).replace("HashMap", "xml").replace("&lt;", "<").replace("&gt;", ">");
	}

}
