/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.log;

import cn.takujo.common_api.log.Administrator;
import cn.takujo.common_api.log.LogData;
import cn.takujo.common_api.log.LogRecord;
import cn.takujo.common_api.log.Logable;
import cn.takujo.common_api.log.Principal;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="@annotation(cn.takujo.common_api.log.Logable)")
    public void webPointCut() {
    }

    @AfterThrowing(value="webPointCut()")
    public void throwss(JoinPoint jp) {
        log.warn("LogAspect afterThrowing: exception erro");
    }

    @Around(value="webPointCut()")
    public Object arround(ProceedingJoinPoint pjp) {
        try {
            Object o = pjp.proceed();
            LogData logData = this.handleService(pjp, o);
            this.logPersistence(logData);
            log.info("save logdata success");
            return o;
        }
        catch (Throwable e) {
            log.warn("LogAspect arround: exception erro");
            e.printStackTrace();
            return null;
        }
    }

    protected abstract String uriToPermStr(String var1);

    protected abstract void logPersistence(LogData var1);

    protected void AuthenticatedAndPermitted(LogData logData, Administrator administrator, String permStr) {
        Integer id = administrator.getId();
        String name = administrator.getName();
        Subject subject = SecurityUtils.getSubject();
        boolean authenticated = subject.isAuthenticated();
        if (authenticated) {
            logData.setOperaterId(id);
            logData.setOperaterName(name);
            if (subject.isPermitted(permStr)) {
                logData.setAllow(1);
            } else {
                logData.setAllow(0);
            }
        } else {
            logData.setAllow(0);
            logData.setOperaterId(0);
            logData.setOperaterName("\u672a\u77e5\u4eba\u5458");
        }
    }

    protected Administrator getAdministrator() {
        Subject subject = SecurityUtils.getSubject();
        Principal pri = (Principal)subject.getPrincipal();
        return pri.getAdministrator();
    }

    private Map<String, Object> handleRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String uri = request.getRequestURI();
        String visitIp = request.getRemoteAddr();
        String permStr = this.uriToPermStr(uri);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("visitIp", visitIp);
        map.put("permStr", permStr);
        return map;
    }

    private LogData handleService(ProceedingJoinPoint pjp, Object result) {
        LogData logData = new LogData();
        logData.setTime(new Date());
        Map<String, Object> handleRequest = this.handleRequest();
        Object vipobject = handleRequest.get("visitIp");
        Object perobject = handleRequest.get("permStr");
        String permStr = null;
        if (vipobject != null) {
            logData.setVisitIp((String)vipobject);
        }
        if (perobject != null) {
            permStr = (String)perobject;
        }
        this.AuthenticatedAndPermitted(logData, this.getAdministrator(), permStr);
        Signature signature = pjp.getSignature();
        Class declaringType = signature.getDeclaringType();
        String methodName = signature.getName();
        Method method = this.getMethod(declaringType, methodName);
        if (method != null) {
            try {
                Object[] args;
                Logable annotation = method.getAnnotation(Logable.class);
                if (annotation != null) {
                    logData.setAction(annotation.action());
                    logData.setType(annotation.type());
                }
                StringBuffer buffer = new StringBuffer("");
                for (Object obj : args = pjp.getArgs()) {
                    if (obj instanceof LogRecord) {
                        LogRecord lr = (LogRecord)obj;
                        buffer.append(lr.toLog() + ",");
                        continue;
                    }
                    if (!(obj instanceof Integer)) continue;
                    buffer.append(obj.toString() + ",");
                }
                int lastIndexOf = buffer.lastIndexOf(",");
                if (lastIndexOf != -1) {
                    buffer.deleteCharAt(lastIndexOf);
                }
                logData.setThing(buffer.toString());
                if (result == null) {
                    logData.setResult(0);
                } else {
                    Integer i;
                    logData.setResult(1);
                    if (result instanceof Integer && (i = (Integer)result) == 0) {
                        logData.setResult(0);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logData.setResult(0);
            }
        }
        return logData;
    }

    private Method getMethod(Class<?> type, String methodName) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = type.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }
}

