/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(MultipartFile file, File save) {
        FilterOutputStream stream = null;
        if (!file.isEmpty()) {
            try {
                log.info("save file: " + save.getAbsolutePath());
                byte[] bytes = file.getBytes();
                stream = new BufferedOutputStream(new FileOutputStream(save));
                stream.write(bytes);
                log.info("upload: success");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                log.warn("upload: failure -> file not found");
            }
            catch (IOException e) {
                e.printStackTrace();
                log.warn("upload: failure -> stream write failure");
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        log.warn("upload: error -> stream close failure");
                    }
                }
                stream = null;
            }
        } else {
            log.warn("upload: failure ->file is Empty");
        }
    }

    public static void deleteFiles(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fs;
                for (File f : fs = file.listFiles()) {
                    FileUtil.deleteFiles(f);
                }
                boolean result = file.delete();
                log.info("delete directory: " + file.getName() + " " + result);
            } else if (file.isFile()) {
                boolean result = file.delete();
                log.info("delete file: " + file.getAbsolutePath() + " " + result);
            }
        }
    }
}

