/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import cn.takujo.common_api.exception.HttpException;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtil {
    private static OkHttpClient ClIENT = new OkHttpClient();
    public static final MediaType JSON = MediaType.get((String)"application/json;charset=utf-8");
    public static final MediaType XML = MediaType.get((String)"text/xml");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String get(String url) throws HttpException {
        Request request = new Request.Builder().url(url).build();
        try (Response response = ClIENT.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new HttpException("http01", "get\u8bf7\u6c42\u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String post(String url, String json) throws HttpException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = ClIENT.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new HttpException("http02", "post\u8bf7\u6c42\u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postByForm(String url, FormBody.Builder parm) throws HttpException {
        FormBody body = parm.build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        try (Response response = ClIENT.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new HttpException("http03", "postByForm\u8bf7\u6c42\u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postByXml(String url, String xml) throws HttpException {
        RequestBody body = RequestBody.create((MediaType)XML, (String)xml);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = ClIENT.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new HttpException("http04", "postByXml\u8bf7\u6c42\u5931\u8d25");
        }
    }
}

