/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import cn.takujo.common_api.exception.PicException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.coobird.thumbnailator.Thumbnails;

public final class PicUtil {
    public static void compress(File picFile, String outFile, double scale, double quality) throws PicException {
        try {
            PicUtil.mkdirs(outFile);
            Thumbnails.of((File[])new File[]{picFile}).scale(scale).outputQuality(quality).toFile(outFile);
        }
        catch (IOException e) {
            throw new PicException("pic01", "\u56fe\u7247\u538b\u7f29\u5931\u8d25");
        }
    }

    public static void compress(File picFile, String outFile, int width, int height, double quality) throws PicException {
        try {
            PicUtil.mkdirs(outFile);
            Thumbnails.of((File[])new File[]{picFile}).size(width, height).outputQuality(quality).toFile(outFile);
        }
        catch (IOException e) {
            throw new PicException("pic02", "\u56fe\u7247\u538b\u7f29\u5931\u8d25");
        }
    }

    public static void compress(InputStream input, String outFile, int width, int height, double quality) throws PicException {
        try {
            PicUtil.mkdirs(outFile);
            Thumbnails.of((InputStream[])new InputStream[]{input}).size(width, height).outputQuality(quality).toFile(outFile);
        }
        catch (IOException e) {
            throw new PicException("pic03", "\u56fe\u7247\u538b\u7f29\u5931\u8d25");
        }
    }

    public static void compress(InputStream input, String outFile, double scale, double quality) throws PicException {
        try {
            PicUtil.mkdirs(outFile);
            Thumbnails.of((InputStream[])new InputStream[]{input}).scale(scale).outputQuality(quality).toFile(outFile);
        }
        catch (IOException e) {
            throw new PicException("pic04", "\u56fe\u7247\u538b\u7f29\u5931\u8d25");
        }
    }

    private static void mkdirs(String outFile) {
        File parent = new File(outFile).getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }
}

