/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import cn.takujo.common_api.exception.BaseException;
import cn.takujo.common_api.util.HttpUtil;
import cn.takujo.common_api.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class WeiXinUtil {
    private String appId;
    private String appSecret;

    public String accessToken() throws BaseException {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.appId + "&secret=" + this.appSecret;
        String tokenId = HttpUtil.get(url);
        Map<String, Object> map = JsonUtil.toMap(tokenId);
        Object token = map.get("access_token");
        if (token != null) {
            return (String)token;
        }
        String errcode = String.valueOf(map.get("errcode"));
        throw new BaseException("WeiXin" + errcode, "\u83b7\u53d6accessToken\u5931\u8d25");
    }

    public boolean sendTemplateMessage(String accessToken, Map<String, Object> map) throws BaseException {
        String url;
        String post;
        String errcode;
        if (accessToken == null) {
            accessToken = this.accessToken();
        }
        if ("0".equals(errcode = String.valueOf(JsonUtil.toMap(post = HttpUtil.post(url = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token=" + accessToken, JsonUtil.toString(map))).get("errcode")))) {
            return true;
        }
        throw new BaseException("WeiXin" + errcode, "\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5931\u8d25");
    }

    public Map<String, Object> templateMessageParamMap(String touser, String templateId, String page, String formId, String emphasisKeyword, List<Map<String, Object>> keywords) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("touser", touser);
        map.put("template_id", templateId);
        map.put("page", page);
        map.put("form_id", formId);
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < keywords.size(); ++i) {
            data.put("keyword" + (i + 1), keywords.get(i));
        }
        map.put("data", data);
        if (emphasisKeyword != null) {
            map.put("emphasis_keyword", emphasisKeyword);
        }
        return map;
    }

    public Map<String, Object> templateMessageKeyword(String value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", value);
        return map;
    }

    public String getOpenid(String code) throws BaseException {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=" + this.appId + "&secret=" + this.appSecret + "&js_code=" + code + "&grant_type=authorization_code";
        String data = HttpUtil.get(url);
        Map<String, Object> map = JsonUtil.toMap(data);
        Object open = map.get("openid");
        if (open != null) {
            return (String)open;
        }
        String errcode = String.valueOf(map.get("errcode"));
        throw new BaseException("WeiXin" + errcode, "\u83b7\u53d6openid\u5931\u8d25");
    }

    public WeiXinUtil(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeiXinUtil)) {
            return false;
        }
        WeiXinUtil other = (WeiXinUtil)o;
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        return !(this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        return result;
    }

    public String toString() {
        return "WeiXinUtil(appId=" + this.getAppId() + ", appSecret=" + this.getAppSecret() + ")";
    }
}

