package cn.takujo.mybatis.assistant;

import java.lang.reflect.Method;

import cn.takujo.mybatis.assistant.exception.SqlMethodCanNotReturnNullException;
import cn.takujo.mybatis.assistant.exception.WrapSqlFailedException;

/**
 * 该接口的实现类应对应mybatis中多种Provider注解中type
 * 
 * @author wzx
 *
 */
public interface ProviderType {

	String sql();

	default String wrap(Object param) {
		String sql = sql();
		Class<? extends ProviderType> pcl = getClass();
		if (sql == null) {
			throw new SqlMethodCanNotReturnNullException("sql method can not return null in " + pcl.getName());
		}
		try {
			Method method = pcl.getMethod("sql");
			String appendSql = MyBatisAssistant.appendSql(method, param);
			return sql + appendSql;
		} catch (Exception e) {
			throw new WrapSqlFailedException(e.getMessage());
		}
	}

}
