package cn.takujo.mybatis.assistant.annotation;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Condition中的Column
 * 
 * @author wzx
 *
 */
@Documented
@Retention(RUNTIME)
@Target(METHOD)
public @interface Column {

	/**
	 * 数据库列名或自定义<br>
	 * 如果自定义的话,Condition中的operator不会起作用<br>
	 * 操作符需自行注入到自定义的column中
	 * 
	 * @return 列名
	 */
	String value();

	/**
	 * 是否自定义，默认false
	 * 
	 * @return true或false
	 */
	boolean isDefined() default false;

}
