package cn.takujo.mybatis.assistant.annotation;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import cn.takujo.mybatis.assistant.sqlsign.Connector;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeConnector;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeOperator;
import cn.takujo.mybatis.assistant.sqlsign.Operator;

/**
 * Where后条件
 * 
 * @author wzx
 *
 */
@Documented
@Retention(RUNTIME)
@Target(METHOD)
public @interface Condition {

	Column column();

	/**
	 * 对应java对象中的属性
	 * 
	 * @return 属性
	 */
	String property();

	/**
	 * 条件连接符 默认为AND
	 * 
	 * @return 连接符
	 */
	Connector connector() default Connector.AND;

	/**
	 * 自定义条件连接符
	 * 
	 * @return 连接符
	 */
	Class<? extends CustomizeConnector> customizeConnector() default CustomizeConnector.class;

	/**
	 * 条件操作符 默认为EQUAL
	 * 
	 * @return 操作符
	 */
	Operator operator() default Operator.EQUAL;

	/**
	 * 自定义条件操作符
	 * 
	 * @return 操作符
	 */
	Class<? extends CustomizeOperator> customizeOperator() default CustomizeOperator.class;

}
