package cn.takujo.mybatis.assistant.annotation;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import cn.takujo.mybatis.assistant.sqlsign.CustomizeSort;
import cn.takujo.mybatis.assistant.sqlsign.Sort;

/**
 * 排序
 * 
 * @author wzx
 *
 */
@Documented
@Retention(RUNTIME)
@Target(METHOD)
public @interface Order {

	/**
	 * 对应数据库中的列
	 * 
	 * @return 列名
	 */
	String column();

	/**
	 * 排序方式，默认升序
	 * 
	 * @return 排序方式
	 */
	Sort sort() default Sort.ASC;

	/**
	 * 自定义排序
	 * 
	 * @return 排序方式
	 */
	Class<? extends CustomizeSort> customizeSort() default CustomizeSort.class;

}
