package cn.takujo.mybatis.assistant.sqlsign;

/**
 * sql符号工厂
 * 
 * @author wzx
 *
 */
public class SqlSignFactory {

	private static final String EQUAL = "=";
	private static final String NO = "!";
	private static final String NOT = "NOT";
	private static final String LESS_THAN = "<";
	private static final String GREATER_THAN = ">";
	private static final String LIKE = "LIKE";
	private static final String SPACE = " ";

	private static final String NO_EQUAL = NO + EQUAL;
	private static final String GREATER_OR_EQUAL = GREATER_THAN + EQUAL;
	private static final String LESS_OR_EQUAL = LESS_THAN + EQUAL;
	private static final String NOT_LIKE = NOT + SPACE + LIKE;

	private static final String AND = "AND";
	private static final String OR = "OR";

	private static final String DESC = "DESC";
	private static final String ASC = "ASC";

	private static final String IN = "IN";
	private static final String NOT_IN = NOT + SPACE + IN;

	/**
	 * 生产操作符
	 * 
	 * @param operator
	 *            操作符枚举
	 * @return 操作符
	 */
	public static String operator(Operator operator) {
		switch (operator) {
		case EQUAL:
			return EQUAL;
		case LESS_THAN:
			return LESS_THAN;
		case GREATER_THAN:
			return GREATER_THAN;
		case LIKE:
			return SPACE + LIKE + SPACE;
		case NO_EQUAL:
			return NO_EQUAL;
		case GREATER_OR_EQUAL:
			return GREATER_OR_EQUAL;
		case LESS_OR_EQUAL:
			return LESS_OR_EQUAL;
		case NOT_LIKE:
			return SPACE + NOT_LIKE + SPACE;
		case IN:
			return SPACE + IN + SPACE;
		case NOT_IN:
			return SPACE + NOT_IN + SPACE;
		default:
			return EQUAL;
		}
	}

	/**
	 * 生产操作符
	 * 
	 * @param operator
	 *            自定义操作符
	 * @return 操作符
	 */
	public static String operator(Class<? extends CustomizeOperator> operator) {
		return customizeSign(operator, CustomizeOperator.class);
	}

	/**
	 * 生产连接符
	 * 
	 * @param connector
	 *            连接符枚举
	 * @return 连接符
	 */
	public static String connector(Connector connector) {
		switch (connector) {
		case AND:
			return SPACE + AND + SPACE;
		case OR:
			return SPACE + OR + SPACE;
		default:
			return SPACE + AND + SPACE;
		}
	}

	/**
	 * 生产连接符
	 * 
	 * @param connector
	 *            自定义连接符
	 * @return 连接符
	 */
	public static String connector(Class<? extends CustomizeConnector> connector) {
		return customizeSign(connector, CustomizeConnector.class);
	}

	/**
	 * 生产排序符
	 * 
	 * @param sort
	 *            排序符枚举
	 * @return 排序符
	 */
	public static String sort(Sort sort) {
		switch (sort) {
		case DESC:
			return SPACE + DESC + SPACE;
		case ASC:
			return SPACE + ASC + SPACE;
		default:
			return SPACE + ASC + SPACE;
		}
	}

	/**
	 * 生产连接符
	 * 
	 * @param sort
	 *            自定义连接符
	 * @return 连接符
	 */
	public static String sort(Class<? extends CustomizeSort> sort) {
		return customizeSign(sort, CustomizeSort.class);
	}

	private static String customizeSign(Class<? extends SqlSign> cus, Class<? extends SqlSign> self) {
		if (cus != self) {
			String create = null;
			try {
				create = cus.newInstance().create();
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
			return create;
		}
		return null;
	}

}
