/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.mybatis.assistant;

import cn.takujo.mybatis.assistant.annotation.Column;
import cn.takujo.mybatis.assistant.annotation.Condition;
import cn.takujo.mybatis.assistant.annotation.Order;
import cn.takujo.mybatis.assistant.annotation.Where;
import cn.takujo.mybatis.assistant.exception.NotSupportMultiParameterInjectionException;
import cn.takujo.mybatis.assistant.sqlsign.Connector;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeConnector;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeOperator;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeSort;
import cn.takujo.mybatis.assistant.sqlsign.Operator;
import cn.takujo.mybatis.assistant.sqlsign.Sort;
import cn.takujo.mybatis.assistant.sqlsign.SqlSignFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public class SqlBuilder {
    public String build(Object param, Where where, Order order) {
        String wh = "";
        if (param != null) {
            if (param instanceof Map) {
                Map map = (Map)param;
                wh = this.mapParam(map, where);
            } else {
                wh = this.beanParam(param, where);
            }
        }
        String or = "";
        if (order != null) {
            String column = order.column();
            Sort sort = order.sort();
            String so = SqlSignFactory.sort(sort);
            Class<? extends CustomizeSort> customizeSort = order.customizeSort();
            String userSort = SqlSignFactory.sort(customizeSort);
            if (userSort != null) {
                so = userSort;
            }
            or = " ORDER BY " + column + so;
        }
        return wh + or;
    }

    private String mapParam(Map map, Where where) {
        if (where != null) {
            Condition[] value = where.value();
            int len = value.length;
            ArrayList<Condition> list = new ArrayList<Condition>();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                Condition condition = value[i];
                String property = condition.property();
                Object object = map.get(property);
                if (object == null) continue;
                list.add(condition);
            }
            boolean b = false;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Condition c = (Condition)list.get(i);
                if (i == size - 1) {
                    b = true;
                }
                sb.append(this.condition(c, b));
            }
            if (sb.length() > 0) {
                return " WHERE " + sb.toString();
            }
            return "";
        }
        return "";
    }

    private String beanParam(Object object, Where where) {
        if (where != null) {
            Class<?> pcl = object.getClass();
            Condition[] value = where.value();
            int len = value.length;
            ArrayList<Condition> list = new ArrayList<Condition>();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                Condition condition = value[i];
                String property = condition.property();
                try {
                    Method method = pcl.getMethod("get" + property.substring(0, 1).toUpperCase() + property.substring(1), new Class[0]);
                    Object invoke = method.invoke(object, new Object[0]);
                    if (invoke == null) continue;
                    list.add(condition);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            boolean b = false;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Condition c = (Condition)list.get(i);
                if (i == size - 1) {
                    b = true;
                }
                sb.append(this.condition(c, b));
            }
            if (sb.length() > 0) {
                return " WHERE " + sb.toString();
            }
            return "";
        }
        return "";
    }

    private String condition(Condition condition, boolean isLast) {
        Column column = condition.column();
        String property = condition.property();
        boolean defined = column.isDefined();
        String value = column.value();
        if (defined) {
            char[] charArray = value.toCharArray();
            int len = charArray.length;
            int indexNum = 0;
            for (int i = 0; i < len; ++i) {
                char c = charArray[i];
                if (c != '?') continue;
                ++indexNum;
            }
            if (indexNum > 1) {
                throw new NotSupportMultiParameterInjectionException("in column ? quantity more than 1");
            }
            if (indexNum == 1) {
                value = value.replace("?", this.wrapProperty(property));
            }
        }
        Operator operator = condition.operator();
        Connector connector = condition.connector();
        String fixedOperator = SqlSignFactory.operator(operator);
        String fixedConnector = SqlSignFactory.connector(connector);
        String oper = fixedOperator;
        String conn = fixedConnector;
        Class<? extends CustomizeOperator> customizeOperator = condition.customizeOperator();
        Class<? extends CustomizeConnector> customizeConnector = condition.customizeConnector();
        String userOperator = SqlSignFactory.operator(customizeOperator);
        String userConnector = SqlSignFactory.connector(customizeConnector);
        if (userOperator != null) {
            oper = userOperator;
        }
        if (userConnector != null) {
            conn = userConnector;
        }
        String result = null;
        result = defined ? value : value + oper + this.wrapProperty(property);
        if (!isLast) {
            result = result + conn;
        }
        return result;
    }

    private String wrapProperty(String property) {
        return "#{" + property + "}";
    }
}

