/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.mybatis.assistant.sqlsign;

import cn.takujo.mybatis.assistant.sqlsign.Connector;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeConnector;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeOperator;
import cn.takujo.mybatis.assistant.sqlsign.CustomizeSort;
import cn.takujo.mybatis.assistant.sqlsign.Operator;
import cn.takujo.mybatis.assistant.sqlsign.Sort;
import cn.takujo.mybatis.assistant.sqlsign.SqlSign;

public class SqlSignFactory {
    private static final String EQUAL = "=";
    private static final String NO = "!";
    private static final String NOT = "NOT";
    private static final String LESS_THAN = "<";
    private static final String GREATER_THAN = ">";
    private static final String LIKE = "LIKE";
    private static final String SPACE = " ";
    private static final String NO_EQUAL = "!=";
    private static final String GREATER_OR_EQUAL = ">=";
    private static final String LESS_OR_EQUAL = "<=";
    private static final String NOT_LIKE = "NOT LIKE";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String DESC = "DESC";
    private static final String ASC = "ASC";
    private static final String IN = "IN";
    private static final String NOT_IN = "NOT IN";

    public static String operator(Operator operator) {
        switch (operator) {
            case EQUAL: {
                return EQUAL;
            }
            case LESS_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN: {
                return GREATER_THAN;
            }
            case LIKE: {
                return " LIKE ";
            }
            case NO_EQUAL: {
                return NO_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return GREATER_OR_EQUAL;
            }
            case LESS_OR_EQUAL: {
                return LESS_OR_EQUAL;
            }
            case NOT_LIKE: {
                return " NOT LIKE ";
            }
            case IN: {
                return " IN ";
            }
            case NOT_IN: {
                return " NOT IN ";
            }
        }
        return EQUAL;
    }

    public static String operator(Class<? extends CustomizeOperator> operator) {
        return SqlSignFactory.customizeSign(operator, CustomizeOperator.class);
    }

    public static String connector(Connector connector) {
        switch (connector) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
        }
        return " AND ";
    }

    public static String connector(Class<? extends CustomizeConnector> connector) {
        return SqlSignFactory.customizeSign(connector, CustomizeConnector.class);
    }

    public static String sort(Sort sort) {
        switch (sort) {
            case DESC: {
                return " DESC ";
            }
            case ASC: {
                return " ASC ";
            }
        }
        return " ASC ";
    }

    public static String sort(Class<? extends CustomizeSort> sort) {
        return SqlSignFactory.customizeSign(sort, CustomizeSort.class);
    }

    private static String customizeSign(Class<? extends SqlSign> cus, Class<? extends SqlSign> self) {
        if (cus != self) {
            String create = null;
            try {
                create = cus.newInstance().create();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return create;
        }
        return null;
    }
}

