/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain;

import cn.tdchain.cipher.utils.HashCheckUtil;
import cn.tdchain.jbcc.DateUtils;
import cn.tdchain.jbcc.SQLCheckUtil;
import cn.tdchain.jbcc.TransInfoException;
import cn.tdchain.jbcc.TransUtil;
import com.alibaba.fastjson.JSON;

public class Trans {
    protected String timestamp;
    protected String preHash = "null";
    protected String hash = "null";
    protected String blockHash;
    protected String key;
    protected String data;
    protected String type = "null";
    protected String connectionId;
    protected TransStatus status = TransStatus.prep;
    protected String msg;
    private Long version;
    private Long height;

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getHeight() {
        return this.height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getPreHash() {
        return this.preHash;
    }

    public void setPreHash(String preHash) {
        this.preHash = preHash;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public TransStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransStatus status) {
        this.status = status;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void upHash() {
        if (this.key == null || this.key.trim().length() == 0 || this.key.trim().length() > 255) {
            throw new TransInfoException("key is null or too long.");
        }
        this.setTimestamp(DateUtils.getCurrentTime());
        if (this.hash != null && this.hash.length() > 0 && !this.hash.equals("null")) {
            this.preHash = this.hash;
        }
        this.hash = this.computHash(this);
    }

    public String computHash(Trans t) {
        return TransUtil.getTransHash(t);
    }

    public void check() {
        if (this.getKey() == null || this.getKey().length() == 0 || this.getKey().length() > 255) {
            throw new TransInfoException("key is null or too long, max size is 255.");
        }
        this.setKey(this.getKey().trim());
        if (HashCheckUtil.illegalCharacterCheck(this.key)) {
            throw new TransInfoException("key have Illegal character.");
        }
        if (HashCheckUtil.illegalCharacterCheck(this.type) || this.type != null && this.type.length() > 45) {
            throw new TransInfoException("type have Illegal character.");
        }
        if (SQLCheckUtil.checkSQLError(this.getKey())) {
            throw new TransInfoException("key have Illegal character.");
        }
        if (this.getData() == null || this.getData().trim().length() == 0 || this.getData().trim().getBytes().length > 65535) {
            throw new TransInfoException("data is null or too long,max byte size is 65535.");
        }
        if (HashCheckUtil.illegalCharacterCheck(this.data)) {
            throw new TransInfoException("data have Illegal character.");
        }
        if (this.getHash() == null || this.getHash().trim().length() != 64) {
            this.upHash();
        }
        if (!HashCheckUtil.hashCheck(this.hash)) {
            throw new TransInfoException("hash error:" + this.hash);
        }
        if (!HashCheckUtil.hashCheck(this.preHash) && !"null".equals(this.preHash)) {
            throw new TransInfoException("pre hash error:" + this.preHash);
        }
        this.checkStartTime();
    }

    protected void checkStartTime() {
        Long differ_time = System.currentTimeMillis() - DateUtils.getTime(this.getTimestamp());
        if (differ_time > 6000L || differ_time < -6000L) {
            throw new TransInfoException("the trans out of time or timestamp is error.");
        }
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }

    public static enum TransStatus {
        prep,
        success,
        failed;

    }
}

