/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.rsa;

import cn.tdchain.cipher.utils.CipherUtil;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesUtil {
    private static ThreadLocal<Cipher> cipherThreadLocal = new ThreadLocal();
    private static Provider provider = new BouncyCastleProvider();
    private static final String VIPARA = "aabbccddeeffgghh";

    private AesUtil() {
    }

    public static String encrypt(String data, String passwd) {
        try {
            Cipher cipher = AesUtil.getCipher(passwd, 1);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            System.out.println("Failed to encrypt data. " + e.getMessage());
            return data;
        }
    }

    public static String decrypt(String data, String passwd) {
        if (data == null || data.length() == 0) {
            return data;
        }
        try {
            byte[] encryptedData = Base64.getDecoder().decode(data);
            Cipher cipher = AesUtil.getCipher(passwd, 2);
            byte[] decryptedData = cipher.doFinal(encryptedData);
            return new String(decryptedData, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            System.out.println("Failed to aes decrypt data." + e.getMessage());
            return null;
        }
    }

    private static Cipher getCipher(String passwd, int mode) throws Exception {
        String formattedPwd = CipherUtil.zeroSuffix(passwd);
        SecretKeySpec key = new SecretKeySpec(formattedPwd.getBytes(StandardCharsets.UTF_8), "AES");
        IvParameterSpec zeroIv = new IvParameterSpec(VIPARA.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = cipherThreadLocal.get();
        if (cipher == null) {
            cipher = Cipher.getInstance("AES", provider);
            cipherThreadLocal.set(cipher);
        }
        cipher.init(mode, (Key)key, zeroIv);
        return cipher;
    }
}

