/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.rsa;

import cn.tdchain.cipher.utils.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class Sha256Util {
    private static ThreadLocal<MessageDigest> digestThreadLocal = new ThreadLocal();

    private Sha256Util() {
    }

    public static String hash(String text) {
        byte[] digest = null;
        try {
            MessageDigest md = digestThreadLocal.get();
            if (md == null) {
                md = MessageDigest.getInstance("SHA-256");
                digestThreadLocal.set(md);
            }
            md.update(text.getBytes(StandardCharsets.UTF_8));
            digest = md.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ByteUtils.byteToHex(digest);
    }
}

