/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.Trans;
import cn.tdchain.jbcc.BatchTransException;
import cn.tdchain.jbcc.MerkleUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BatchTrans<T extends Trans> {
    private int index = 1;
    private String id = null;
    private String connectionId;
    private String msg;
    private Long timeStamp;
    private Trans.TransStatus status = Trans.TransStatus.prep;
    private HashSet<String> keySet = new HashSet();
    private HashSet<T> transSet = new HashSet();

    public BatchTrans() {
        this.timeStamp = System.currentTimeMillis();
    }

    public void addTransToBatch(T t) {
        ((Trans)t).check();
        if (this.keySet.contains(((Trans)t).getKey()) || this.transSet.contains(t)) {
            throw new BatchTransException("batch trans exist key:" + ((Trans)t).getKey());
        }
        this.transSet.add(t);
        this.keySet.add(((Trans)t).getKey());
    }

    public void addTransToBatch(List<T> transList) {
        for (int i = 0; transList != null && i < transList.size(); ++i) {
            Trans t = (Trans)transList.get(i);
            this.addTransToBatch(t);
        }
    }

    public List<String> hashListfromBatch() {
        ArrayList<String> hashList = new ArrayList<String>(this.keySet.size() + 3);
        for (Trans t : this.transSet) {
            if (t == null) continue;
            hashList.add(t.getHash());
        }
        return hashList;
    }

    public int sizeFromBatch() {
        return this.transSet.size();
    }

    public boolean isExistKeys(HashSet keySet) {
        return this.keySet.contains(keySet);
    }

    public void check() {
        if (this.sizeFromBatch() == 0) {
            throw new BatchTransException("batch size is zero");
        }
        if (this.status != Trans.TransStatus.prep) {
            throw new BatchTransException("status is not prep");
        }
        String t_id = MerkleUtil.getMerkleRoot(this.hashListfromBatch());
        if (this.id == null) {
            this.id = t_id;
        } else if (!t_id.equals(this.id)) {
            throw new BatchTransException("check this batch id is fail");
        }
        HashSet<String> t_keySet = new HashSet<String>();
        for (Trans t : this.transSet) {
            if (t == null) {
                throw new BatchTransException("trans is null");
            }
            t.check();
            if (t_keySet.contains(t.getKey())) {
                throw new BatchTransException("repeated key:" + t.getKey());
            }
            t_keySet.add(t.getKey());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HashSet<String> getKeySet() {
        return this.keySet;
    }

    public void setKeySet(HashSet<String> keySet) {
        this.keySet = keySet;
    }

    public HashSet<T> getTransSet() {
        return this.transSet;
    }

    public void setTransSet(HashSet<T> transSet) {
        this.transSet = transSet;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String toJsonString() {
        return JSONObject.toJSONString((Object)this);
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Trans.TransStatus getStatus() {
        return this.status;
    }

    public void setStatus(Trans.TransStatus status) {
        this.status = status;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void batchSetMsg(String message) {
        this.setMsg(message);
        for (Trans t : this.transSet) {
            if (t == null) continue;
            t.setMsg(message);
        }
    }

    public void batchSetStatus(Trans.TransStatus status) {
        this.setStatus(status);
        for (Trans t : this.transSet) {
            if (t == null) continue;
            t.setStatus(status);
        }
    }

    public Trans oneTrans() {
        Iterator<T> iterator = this.transSet.iterator();
        if (iterator.hasNext()) {
            Trans t = (Trans)iterator.next();
            return t;
        }
        return null;
    }

    public String[] keyToArray() {
        String[] keys = new String[this.keySet.size()];
        this.keySet.toArray(keys);
        return keys;
    }
}

