/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.Block;
import cn.tdchain.Trans;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.Key;
import cn.tdchain.cipher.utils.HashCheckUtil;
import cn.tdchain.jbcc.BatchTrans;
import cn.tdchain.jbcc.BlockException;
import cn.tdchain.jbcc.ManagerTransactionPool;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.ParameterException;
import cn.tdchain.jbcc.SQLCheckUtil;
import cn.tdchain.jbcc.TransInfoException;
import cn.tdchain.jbcc.TransUtil;
import cn.tdchain.jbcc.Transaction;
import cn.tdchain.jbcc.net.Net;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class Connection {
    private Key key = new Key();
    private Cipher cipher = null;
    private String[] ipTable = null;
    private int port = 18088;
    private long timeOut = 3000L;
    private int poolSize = 3;
    private String ksPath = "";
    private String ksPasswd = "123456";
    private String token = "1234567890123456";
    private String connectionId = UUID.randomUUID().toString();
    protected Net net;
    private int minSucces = 1;

    public Connection(String[] ipTable, int port, String ksPath, String ksPasswd, String token, Cipher cipher, String prikeyAlias, String prikePass, String pubKeyAlias) {
        this(ipTable, port, 3000L, ksPath, ksPasswd, token, cipher, prikeyAlias, pubKeyAlias);
    }

    public Connection(String[] ipTable, int port, Key key, String token, Cipher cipher) {
        this.ipTable = ipTable;
        this.port = port;
        this.key = key;
        this.token = token;
        this.minSucces = PBFT.getMinByCount(ipTable.length);
        this.synAskNodes();
        this.startNet(token, cipher);
    }

    public Connection(String[] ipTable, int port, long timeOut, String ksPath, String ksPasswd, String token, Cipher cipher, String prikeyAlias, String pubKeyAlias) {
        this.ipTable = ipTable;
        this.port = port;
        this.timeOut = timeOut;
        this.ksPath = ksPath;
        this.ksPasswd = ksPasswd;
        this.token = token;
        this.minSucces = PBFT.getMinByCount(ipTable.length);
        this.init(ksPath, ksPasswd, token, cipher, prikeyAlias, pubKeyAlias);
    }

    public Trans addTrans(Trans t) {
        BatchTrans<Trans> batch = new BatchTrans<Trans>();
        batch.setConnectionId(this.connectionId);
        batch.addTransToBatch(t);
        batch = this.addBatchTrans(batch);
        return batch.oneTrans();
    }

    public BatchTrans<Trans> addBatchTrans(BatchTrans<Trans> batch) {
        batch.setConnectionId(this.connectionId);
        batch.check();
        RPCMessage msg = this.getMessage();
        msg.setMessageId(batch.getId());
        msg.setMsg(batch.toJsonString());
        msg.setTargetType(RPCMessage.TargetType.TX_WAIT);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 12000L);
        int succesCount = 0;
        int failCount = 0;
        BatchTrans succes_batch = null;
        BatchTrans fail_batch = null;
        for (RPCResult r : r_list) {
            BatchTrans t_batch = null;
            if (r == null || r.getEntity() == null || r.getType() != RPCResult.ResultType.tx_status) continue;
            try {
                t_batch = (BatchTrans)JSON.parseObject((String)r.getEntity(), (TypeReference)new TypeReference<BatchTrans<Trans>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (t_batch != null) {
                ++succesCount;
                succes_batch = t_batch;
                continue;
            }
            ++failCount;
            fail_batch = t_batch;
        }
        if (succesCount >= this.minSucces || succesCount > failCount) {
            return succes_batch;
        }
        return fail_batch;
    }

    public Block<Trans> getBlock(Long height) {
        Block b = null;
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("height", height.toString());
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_BLOCK);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 10000L);
        for (RPCResult r : r_list) {
            if (r == null || r.getType() != RPCResult.ResultType.block || r.getEntity() == null) continue;
            try {
                b = (Block)JSON.parseObject((String)r.getEntity(), (TypeReference)new TypeReference<Block<Trans>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (b == null) continue;
            try {
                b.check();
                return b;
            }
            catch (BlockException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected RPCMessage getMessage() {
        RPCMessage msg = new RPCMessage();
        msg.setSender(this.connectionId);
        return msg;
    }

    public Block<Trans> getMaxBlock() {
        return this.getBlock(-1L);
    }

    public Trans getTransByHash(String hash) {
        boolean hashStatus = HashCheckUtil.hashCheck(hash);
        if (!hashStatus) {
            return null;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("hash", hash);
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_HASH);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 6000L);
        return this.getTransByResult(r_list);
    }

    public List<Trans> getTransListByHashList(List<String> hashList) {
        List<Trans> t_list = null;
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("hashList", JSONObject.toJSONString(hashList));
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_LIST);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 5000L);
        t_list = this.getTransListByResultList(t_list, r_list);
        return t_list;
    }

    public Trans getNewTransByKey(String key) {
        boolean sqlStatus = SQLCheckUtil.checkSQLError(key = key.trim());
        if (sqlStatus) {
            return null;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("key", key);
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_KEY);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 3000L);
        return this.getTransByResult(r_list);
    }

    public List<Trans> getTransListByType(String type) {
        if (HashCheckUtil.illegalCharacterCheck(type) || type == null || type.length() > 45) {
            throw new TransInfoException("type have Illegal character or length too long.");
        }
        List<Trans> t_list = null;
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("type", type);
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_LIST_BY_TYPE);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 5000L);
        t_list = this.getTransListByResultList(t_list, r_list);
        return t_list;
    }

    public List<Trans> getTransHistoryByKey(String key, int startIndex, int endIndex) {
        List<Trans> t_list = null;
        if (startIndex < 0 || startIndex > endIndex || endIndex - startIndex > 30) {
            throw new ParameterException("startIndex < 0 || startIndex > endIndex || ((endIndex - startIndex) > 30)");
        }
        boolean sqlStatus = SQLCheckUtil.checkSQLError(key);
        if (sqlStatus) {
            return t_list;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("key", key);
        command.put("startIndex", startIndex + "");
        command.put("endIndex", endIndex + "");
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_HISTORY);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 8000L);
        t_list = this.getTransListByResultList(t_list, r_list);
        return t_list;
    }

    private List<Trans> getTransListByResultList(List<Trans> t_list, List<RPCResult> r_list) {
        for (RPCResult r : r_list) {
            if (r == null || r.getType() != RPCResult.ResultType.tx_list || r.getEntity() == null) continue;
            try {
                t_list = JSON.parseArray((String)r.getEntity(), Trans.class);
                if (t_list == null) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        return t_list;
    }

    public boolean startTransaction(String[] keys) {
        if (keys != null && keys.length > 0) {
            Transaction t = new Transaction(keys);
            return ManagerTransactionPool.register(t, 6000L);
        }
        return false;
    }

    public void stopTransaction(String[] keys) {
        if (keys != null && keys.length > 0) {
            Transaction t = new Transaction(keys);
            ManagerTransactionPool.destroy(t);
        }
    }

    private Trans getTransByResult(List<RPCResult> r_list) {
        int succesCount = 0;
        int failCount = 0;
        Trans succes_t = null;
        Trans fail_t = null;
        for (RPCResult r : r_list) {
            Trans r_t = null;
            if (r == null || r.getEntity() == null || r.getType() != RPCResult.ResultType.tx_status) continue;
            try {
                r_t = (Trans)JSONObject.parseObject((String)r.getEntity(), Trans.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (r_t != null && TransUtil.getTransHash(r_t).equals(r_t.getHash())) {
                ++succesCount;
                succes_t = r_t;
                continue;
            }
            ++failCount;
            fail_t = r_t;
        }
        if (succesCount >= this.minSucces || succesCount > failCount) {
            return succes_t;
        }
        return fail_t;
    }

    private void init(String ksPath, String ksPasswd, String token, Cipher cipher, String prikeyAlias, String pubKeyAlias) {
        try {
            String privateKey = cipher.getPrivateKeyStringByKeyStore(ksPath, ksPasswd, prikeyAlias);
            String publicKey = cipher.getPublicKeyStringByStore(ksPath, ksPasswd, pubKeyAlias);
            this.key.setPrivateKey(privateKey);
            this.key.setPublicKey(publicKey);
        }
        catch (Exception e) {
            throw new CipherException("get private key by key store error:" + e.getMessage());
        }
        this.synAskNodes();
        this.startNet(token, cipher);
    }

    private void startNet(String token, Cipher cipher) {
        if (token == null || token.length() == 0) {
            throw new ParameterException("token is null");
        }
        this.net = new NioNet(this.ipTable, this.port, cipher, token, this.key, this.connectionId);
        this.net.start();
        while (this.net.getTaskSize() < this.net.getMinNodeSize()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void synAskNodes() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            RPCMessage msg = Connection.this.getMessage();
                            msg.setTargetType(RPCMessage.TargetType.GET_NODE_LIST);
                            msg.setMessageId(UUID.randomUUID().toString());
                            Connection.this.net.request(msg);
                            List nodes = new ArrayList();
                            List<RPCResult> r_list = Connection.this.net.resphone(msg.getMessageId(), Connection.this.timeOut);
                            for (RPCResult r : r_list) {
                                List t_nodes;
                                if (r == null || r.getType() != RPCResult.ResultType.node_list || r.getEntity() == null || (t_nodes = JSONObject.parseArray((String)r.getEntity(), Node.class)) == null || t_nodes.size() <= 0 || t_nodes.size() <= nodes.size()) continue;
                                nodes = t_nodes;
                            }
                            for (int i = 0; nodes != null && i < nodes.size(); ++i) {
                                Node n = (Node)nodes.get(i);
                                System.out.println("copy node id:" + n.getId() + " status=" + (Object)((Object)n.getStatus()));
                                Connection.this.net.addNodeToNodes(n);
                            }
                            Thread.sleep(3000L);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public List<Node> getBlockChainNodeStatus() {
        List<Node> nodes = this.net.getNodes();
        return nodes;
    }

    protected String getConnectionId() {
        return this.connectionId;
    }
}

