/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.Trans;
import cn.tdchain.cipher.rsa.Sha256Util;
import cn.tdchain.cipher.utils.HashCheckUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class TransUtil {
    public static String getTransHash(Trans tx) {
        JSONObject txJsonO = JSONObject.parseObject((String)JSON.toJSONString((Object)tx));
        txJsonO.remove((Object)"hash");
        txJsonO.remove((Object)"blockHash");
        txJsonO.remove((Object)"connectionId");
        txJsonO.remove((Object)"status");
        txJsonO.remove((Object)"msg");
        txJsonO.remove((Object)"index");
        txJsonO.remove((Object)"preHash");
        txJsonO.remove((Object)"author");
        txJsonO.remove((Object)"version");
        txJsonO.remove((Object)"height");
        String txJsonStr = txJsonO.toJSONString();
        String hash = Sha256Util.hash(txJsonStr);
        return hash;
    }

    public static Long getHeightByHeightHash(String heightHash) throws Exception {
        if (heightHash != null && heightHash.length() > 0) {
            String[] str = heightHash.split("_");
            if (str.length == 2) {
                return Long.valueOf(str[0]);
            }
            throw new Exception("get height by heightHash=" + heightHash + " error");
        }
        throw new Exception("get height by heightHash=" + heightHash + " error, heightHash is null or empty");
    }

    public static String getHashByHeightHash(String heightHash) throws Exception {
        if (heightHash != null && heightHash.length() > 0) {
            String[] str = heightHash.split("_");
            if (str.length == 2) {
                return str[1];
            }
            return heightHash;
        }
        throw new Exception("get hash by heightHash=" + heightHash + " error, heightHash is null or empty");
    }

    public static String setHeightHash(Long height, String hash) throws Exception {
        if (height == null || height <= 0L) {
            throw new Exception("set heightHash is error, height=" + height + " is null or less than 0");
        }
        if (!HashCheckUtil.hashCheck(hash)) {
            throw new Exception("set heightHash is error, hash=" + hash + " is null or illegal");
        }
        return height + "_" + hash;
    }
}

