/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.io;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.DataCipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.net.io.IONet;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.exception.RpcException;
import cn.tdchain.jbcc.rpc.io.client.RpcClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Resphone {
    private IONet.Task task;
    private String ip;
    private int workerNum = 3;
    private ResphonePool pool;
    private Cipher cipher;
    private Key key;
    private boolean status = true;
    private String connectionId;
    private String serverPublicKey;

    public Resphone(IONet.Task task, String serverIp, String connectionId, Key key, Cipher cipher, int workerNum, String serverPublicKey) {
        this.task = task;
        this.ip = serverIp;
        this.connectionId = connectionId;
        this.key = key;
        this.cipher = cipher;
        if (workerNum > this.workerNum) {
            this.workerNum = workerNum;
        }
        this.serverPublicKey = serverPublicKey;
        this.pool = new ResphonePool(task);
    }

    public void start() {
        this.pool.start();
        if (this.status) {
            long wait_time = 20L;
            for (int i = 0; i < this.workerNum; ++i) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int error_num = 0;
                        while (Resphone.this.status) {
                            RPCMessage batch_msg = new RPCMessage();
                            batch_msg.setTarget(Resphone.this.ip);
                            batch_msg.setTargetType(RPCMessage.TargetType.BATCH_RESPHONE);
                            batch_msg.setSender(Resphone.this.connectionId);
                            RpcClient client = null;
                            try {
                                client = Resphone.this.task.getClient();
                                while (Resphone.this.status) {
                                    try {
                                        client.send(batch_msg.toJsonString());
                                        while (true) {
                                            String r_str;
                                            if ((r_str = client.readResult()) != null && r_str.length() > 0) {
                                                try {
                                                    RPCResult r = (RPCResult)JSONObject.parseObject((String)r_str, RPCResult.class);
                                                    if (r != null && r.getType() == RPCResult.ResultType.batch_resphone) {
                                                        String cipher_data = r.getEntity();
                                                        DataCipher data = (DataCipher)JSONObject.parseObject((String)cipher_data, DataCipher.class);
                                                        String data_str = data.getData(Resphone.this.key.getPrivateKey(), Resphone.this.cipher);
                                                        if (data_str == null) continue;
                                                        Map connectionMap = (Map)JSON.parseObject((String)data_str, (TypeReference)new TypeReference<Map<String, RPCResult>>(){}, (Feature[])new Feature[0]);
                                                        if (connectionMap != null && connectionMap.size() > 0) {
                                                            Resphone.this.pool.add(connectionMap);
                                                        }
                                                    }
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            error_num = 0;
                                        }
                                    }
                                    catch (SocketTimeoutException e) {
                                        e.printStackTrace();
                                    }
                                    catch (ConnectException e) {
                                        error_num = this.close(error_num, client, e);
                                    }
                                    catch (IOException e) {
                                        error_num = this.close(error_num, client, e);
                                    }
                                    catch (RpcException e) {
                                        error_num = this.close(error_num, client, e);
                                    }
                                    catch (Exception e) {
                                        error_num = this.close(error_num, client, e);
                                    }
                                    if (error_num <= 5) continue;
                                    Resphone.this.task.stop();
                                }
                            }
                            catch (SocketTimeoutException e) {
                                e.printStackTrace();
                            }
                            catch (ConnectException e) {
                                error_num = this.close(error_num, client, e);
                            }
                            catch (IOException e) {
                                error_num = this.close(error_num, client, e);
                            }
                            catch (RpcException e) {
                                error_num = this.close(error_num, client, e);
                            }
                            catch (Exception e) {
                                error_num = this.close(error_num, client, e);
                            }
                            if (error_num <= 5) continue;
                            Resphone.this.task.stop();
                        }
                    }

                    private int close(int error_num, RpcClient client, Exception e) {
                        ++error_num;
                        if (client != null) {
                            client.close(e);
                        }
                        return error_num;
                    }
                }).start();
                try {
                    Thread.sleep(wait_time / (long)this.workerNum);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void stop() {
        this.status = false;
        this.pool.stop();
    }

    public RPCResult poll(String messageId) {
        return this.pool.poll(messageId);
    }

    public class ResphonePool {
        private IONet.Task task = null;
        private boolean status = true;
        private ConcurrentHashMap<String, RPCResult> resphonePool = new ConcurrentHashMap();

        public ResphonePool(IONet.Task task) {
            this.task = task;
        }

        public RPCResult poll(String messageId) {
            try {
                return this.resphonePool.remove(messageId);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private synchronized void add(Map<String, RPCResult> connectionMap) {
            this.resphonePool.putAll(connectionMap);
        }

        public void stop() {
            this.status = false;
        }

        public void start() {
            this.status = true;
            this.checkTimeOut(4000L);
        }

        private void checkTimeOut(final long timeOut) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (ResphonePool.this.status) {
                        long now_time = System.currentTimeMillis();
                        try {
                            RPCResult error_r = (RPCResult)ResphonePool.this.resphonePool.remove(RPCResult.PRC_RESULT_DESCRYPT_ERROR);
                            if (error_r != null && error_r.getType() == RPCResult.ResultType.msg_error && error_r.getStatus() == RPCResult.StatusType.fail) {
                                ResphonePool.this.task.stop();
                                return;
                            }
                            ResphonePool.this.resphonePool.forEach((k, v) -> {
                                if (v != null && now_time - v.getStartTime() > timeOut) {
                                    ResphonePool.this.resphonePool.remove(v.getMessageId());
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            Thread.sleep(timeOut * 2L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }).start();
        }
    }
}

