/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.io.client;

import cn.tdchain.jbcc.rpc.io.eclc.EclcSocket;
import com.alibaba.fastjson.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class RpcClient {
    private String serverPublicKey = null;
    private String clientPublicKey = null;
    private String token = "tiande@123456AbC";
    private String address;
    private int port;
    private int timeOut = 3000;
    private EclcSocket socket = null;

    public RpcClient(String address, int port, int timeOut, String token, String clientPublicKey) throws IOException, Exception {
        this.address = address;
        this.port = port;
        this.timeOut = timeOut;
        this.token = token;
        this.clientPublicKey = clientPublicKey;
        this.newSocket();
    }

    private synchronized void newSocket() throws IOException, Exception {
        if (this.socket != null) {
            this.close(null);
        }
        if (this.socket == null) {
            this.socket = new EclcSocket(this.clientPublicKey);
            this.socket.connect(new InetSocketAddress(this.address, this.port), this.timeOut, this.token);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(this.timeOut);
            this.serverPublicKey = this.socket.getServerPublicKey();
        }
    }

    public void send(String msg) throws SocketException, IOException, Exception {
        if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
            this.newSocket();
        }
        OutputStreamWriter os = new OutputStreamWriter(this.socket.getOutputStream());
        BufferedWriter oos = new BufferedWriter(os);
        oos.write(msg);
        oos.newLine();
        oos.flush();
    }

    public String sendAndReturn(String msg) throws SocketException, IOException, Exception {
        if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
            this.newSocket();
        }
        OutputStreamWriter os = new OutputStreamWriter(this.socket.getOutputStream());
        BufferedWriter oos = new BufferedWriter(os);
        oos.write(msg);
        this.socket.setSoTimeout(10000);
        InputStreamReader read = new InputStreamReader(this.socket.getInputStream());
        BufferedReader bfr = new BufferedReader(read);
        oos.newLine();
        oos.flush();
        Thread.sleep(1L);
        return bfr.readLine();
    }

    public void close(Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        IOUtils.close((Closeable)this.socket);
        this.socket = null;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public String readResult() throws IOException, Exception {
        if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
            this.newSocket();
        }
        this.socket.setSoTimeout(0);
        InputStreamReader read = new InputStreamReader(this.socket.getInputStream());
        BufferedReader bfr = new BufferedReader(read);
        return bfr.readLine();
    }
}

