/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.io.eclc;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.jbcc.rpc.BlackList;
import cn.tdchain.jbcc.rpc.io.eclc.ClientSocket;
import cn.tdchain.jbcc.rpc.io.eclc.EclcException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.UUID;

public class EclcServerSocket
extends ServerSocket {
    private String serverPublicKey = null;
    private String passwd = "1234567890123456";
    private long timeOut = 5000L;

    public EclcServerSocket(int port, String passwd, String serverPublicKey) throws IOException {
        super(port);
        this.passwd = passwd;
        this.serverPublicKey = serverPublicKey;
    }

    public EclcServerSocket(int port, int backlog, InetAddress bindAddr, String passwd, String serverPublicKey) throws IOException {
        super(port, backlog, bindAddr);
        this.passwd = passwd;
        this.serverPublicKey = serverPublicKey;
    }

    public EclcServerSocket(int port, int backlog, String passwd, String serverPublicKey) throws IOException {
        super(port, backlog);
        this.passwd = passwd;
        this.serverPublicKey = serverPublicKey;
    }

    public ClientSocket accept2() throws IOException {
        ClientSocket clientSocket = null;
        Socket client = super.accept();
        if (client.isConnected()) {
            if (BlackList.isBlackListByHost(client.getLocalAddress().getHostAddress())) {
                if (client != null) {
                    client.close();
                }
                throw new EclcException("Eclc  failed! this host is a blacklist.");
            }
            OutputStreamWriter os = new OutputStreamWriter(client.getOutputStream());
            BufferedWriter bwrite = new BufferedWriter(os);
            InputStreamReader ir = new InputStreamReader(client.getInputStream());
            BufferedReader bread = new BufferedReader(ir);
            Result result1 = new Result();
            try {
                this.waitLine(result1, bread);
            }
            catch (Exception e) {
                BlackList.addBlackListByHost(client.getLocalAddress().getHostAddress());
                if (client != null) {
                    client.close();
                }
                throw new EclcException(e.getMessage());
            }
            String c_data = AesUtil.decrypt(result1.line, this.passwd);
            String s_data = UUID.randomUUID().toString();
            String s_r_data = c_data + ";" + AesUtil.encrypt(s_data, this.passwd);
            bwrite.write(s_r_data);
            bwrite.newLine();
            bwrite.flush();
            Result result2 = new Result();
            try {
                this.waitLine(result2, bread);
            }
            catch (Exception e) {
                BlackList.addBlackListByHost(client.getLocalAddress().getHostAddress());
                if (client != null) {
                    client.close();
                }
                throw new EclcException(e.getMessage());
            }
            if (!s_data.equals(result2.line)) {
                BlackList.addBlackListByHost(client.getLocalAddress().getHostAddress());
                if (client != null) {
                    client.close();
                }
                throw new EclcException("Eclc  failed! passwd is not agreement.");
            }
            bwrite.write(this.serverPublicKey);
            bwrite.newLine();
            bwrite.flush();
            String clientPubliKey = bread.readLine();
            clientSocket = new ClientSocket(client, clientPubliKey);
            client.setSoTimeout(0);
            return clientSocket;
        }
        throw new EclcException("Eclc  failed! client is not connection.");
    }

    private void waitLine(final Result result, final BufferedReader bread) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    result.line = bread.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeOut && (result.line == null || result.line.length() <= 0)) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (result.line == null) {
            throw new EclcException("read time out.");
        }
    }

    class Result {
        public String line;

        Result() {
        }
    }
}

