/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.cipher.DataCipher;
import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.net.nio.NioResphone;
import cn.tdchain.jbcc.rpc.RPCResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Map;

public class NioResponseClientHandler
extends ChannelInboundHandlerAdapter {
    private int errorNum = 0;
    private NioResphone nioResphone;
    private NioNet.NioTask task;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String message = (String)msg;
        RPCResult r = (RPCResult)JSONObject.parseObject((String)message, RPCResult.class);
        if (r != null && r.getType() == RPCResult.ResultType.batch_resphone) {
            String cipher_data = r.getEntity();
            DataCipher data = (DataCipher)JSONObject.parseObject((String)cipher_data, DataCipher.class);
            String data_str = data.getData(this.nioResphone.getKey().getPrivateKey(), this.nioResphone.getCipher());
            if (data_str == null) {
                return;
            }
            Map connectionMap = (Map)JSON.parseObject((String)data_str, (TypeReference)new TypeReference<Map<String, RPCResult>>(){}, (Feature[])new Feature[0]);
            if (connectionMap != null && connectionMap.size() > 0) {
                this.nioResphone.getPool().add(connectionMap);
            }
        }
        this.errorNum = 0;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.task != null && !this.task.getRpcPool().isAlived()) {
            this.task.setStatus(false);
        }
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        ++this.errorNum;
        System.out.println("\u6253\u5370:get an error times:" + this.errorNum);
        cause.printStackTrace();
        if (this.errorNum >= 5) {
            this.errorNum = 0;
            if (this.task != null) {
                this.task.setStatus(false);
            }
        }
    }

    public NioResphone getNioResphone() {
        return this.nioResphone;
    }

    public void setNioResphone(NioResphone nioResphone) {
        this.nioResphone = nioResphone;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    public void setErrorNum(int errorNum) {
        this.errorNum = errorNum;
    }

    public NioNet.NioTask getTask() {
        return this.task;
    }

    public void setTask(NioNet.NioTask task) {
        this.task = task;
    }
}

