/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.ca.root;

import cn.tdchain.cipher.utils.StringUtils;
import cn.tdchain.tdmsp.ca.config.KeyStoreParam;
import cn.tdchain.tdmsp.ca.config.SystemConfig;
import cn.tdchain.tdmsp.util.PkiUtil;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RsaCertificate {
    protected static SystemConfig systemConfig;

    public void creatRootCA() {
        this.createRoot();
    }

    public void creatOuCert(KeyStoreParam keyStoreParam) {
        this.creatOrganizationCert(keyStoreParam);
    }

    public void creatOuCert(KeyStoreParam keyStoreParam, KeyStore rootkeyStore) {
        this.creatOrganizationCert(keyStoreParam, rootkeyStore);
    }

    protected void createRoot() {
        this.checkConfig(systemConfig);
        String[] issuer = systemConfig.getIssuerdn().split("@");
        X500Name x500Name = PkiUtil.getNameBuilder(issuer[0], issuer[1], issuer[2]);
        try {
            KeyPair keyPair = this.generateKeyPair();
            PublicKey pulickey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)pulickey.getEncoded());
            byte[] certBuf = PkiUtil.getRootEncodedHolder(subPubKeyInfo, x500Name, Integer.valueOf(systemConfig.getValidTime()), x500Name, privateKey, this.getAlgorithm());
            ByteArrayInputStream inStream = new ByteArrayInputStream(certBuf);
            X509Certificate rootCA = (X509Certificate)CertificateFactory.getInstance("X509", "BC").generateCertificate(inStream);
            KeyStoreParam param = new KeyStoreParam(systemConfig.getAlias(), null, systemConfig.getPrivateKeyAlias(), systemConfig.getPrivateKeyPassword(), systemConfig.getKsPassword(), systemConfig.getKsPath(), systemConfig.getKsFileName(), new X509Certificate[]{rootCA}, null, 0);
            PkiUtil.saveToKeystore(param, privateKey, "PKCS12");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void creatOrganizationCert(KeyStoreParam keyStoreParam) {
        this.checkConfig(systemConfig);
        this.checkKeyStoreParam(keyStoreParam);
        try {
            KeyPair keyPair = this.generateKeyPair();
            KeyStore rootCaStore = this.getRootCaStore();
            X509Certificate rootCert = (X509Certificate)rootCaStore.getCertificate(systemConfig.getAlias());
            X500Principal x500Principal = rootCert.getIssuerX500Principal();
            X500Name issuerDn = new X500Name(x500Principal.getName());
            PrivateKey rootPrivateKey = (PrivateKey)rootCaStore.getKey(systemConfig.getPrivateKeyAlias(), systemConfig.getPrivateKeyPassword().toCharArray());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            X500Name x500Name = PkiUtil.getOuNameBuilder(keyStoreParam.getCommonName(), keyStoreParam.getOrganizationUnit(), keyStoreParam.getCountry());
            byte[] certBuf = PkiUtil.getEncodedHolder(subPubKeyInfo, issuerDn, keyStoreParam.getValidTime(), x500Name, rootPrivateKey, this.getAlgorithm(), rootCert.getPublicKey());
            ByteArrayInputStream inStream = new ByteArrayInputStream(certBuf);
            X509Certificate organizationCert = (X509Certificate)CertificateFactory.getInstance("X509", "BC").generateCertificate(inStream);
            X509Certificate[] chain = new X509Certificate[]{organizationCert, rootCert};
            keyStoreParam.setChain(chain);
            PkiUtil.saveToKeystore(keyStoreParam, keyPair.getPrivate(), "PKCS12");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void creatOrganizationCert(KeyStoreParam keyStoreParam, KeyStore rootkeyStore) {
        try {
            KeyPair keyPair = this.generateKeyPair();
            X509Certificate rootCert = (X509Certificate)rootkeyStore.getCertificate(systemConfig.getAlias());
            X500Principal x500Principal = rootCert.getIssuerX500Principal();
            X500Name issuerDn = new X500Name(x500Principal.getName());
            PrivateKey rootPrivateKey = (PrivateKey)rootkeyStore.getKey(systemConfig.getPrivateKeyAlias(), systemConfig.getPrivateKeyPassword().toCharArray());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            X500Name x500Name = PkiUtil.getOuNameBuilder(keyStoreParam.getCommonName(), keyStoreParam.getOrganizationUnit(), keyStoreParam.getCountry());
            byte[] certBuf = PkiUtil.getEncodedHolder(subPubKeyInfo, issuerDn, keyStoreParam.getValidTime(), x500Name, rootPrivateKey, this.getAlgorithm(), rootCert.getPublicKey());
            ByteArrayInputStream inStream = new ByteArrayInputStream(certBuf);
            X509Certificate organizationCert = (X509Certificate)CertificateFactory.getInstance("X509", "BC").generateCertificate(inStream);
            X509Certificate[] chain = new X509Certificate[]{organizationCert, rootCert};
            keyStoreParam.setChain(chain);
            PkiUtil.saveToKeystore(keyStoreParam, keyPair.getPrivate(), "PKCS12");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getAlgorithm() {
        return "SHA256withRSA";
    }

    protected KeyPair generateKeyPair() throws Exception {
        return PkiUtil.generateRsaKeyPair();
    }

    private KeyStore getRootCaStore() {
        try {
            return PkiUtil.getKeyStore(systemConfig.getKsPath() + systemConfig.getKsFileName(), systemConfig.getKsPassword(), "PKCS12");
        }
        catch (Exception e) {
            return null;
        }
    }

    public void certRevocation(X509Certificate endCert, int reason) throws Exception {
        KeyStore enrollCaStore = this.getRootCaStore();
        X509Certificate rootCert = (X509Certificate)enrollCaStore.getCertificate(systemConfig.getAlias());
        PrivateKey privateKey = (PrivateKey)enrollCaStore.getKey(systemConfig.getPrivateKeyAlias(), systemConfig.getPrivateKeyPassword().toCharArray());
        X509v2CRLBuilder builder = new X509v2CRLBuilder(new X500Name(rootCert.getSubjectDN().getName()), new Date());
        builder.addCRLEntry(endCert.getSerialNumber(), new Date(), reason);
        X509CRLHolder crlHolder = builder.build(PkiUtil.getSigner(privateKey, this.getAlgorithm()));
        JcaX509CRLConverter converter = new JcaX509CRLConverter().setProvider("BC");
        X509CRL x509crl = converter.getCRL(crlHolder);
    }

    private void checkConfig(SystemConfig systemConfig) {
        if (StringUtils.isBlank(systemConfig.getIssuerdn())) {
            throw new RuntimeException("Please configure issuerdn in the application.properties");
        }
        if (StringUtils.isBlank(systemConfig.getAlias())) {
            throw new RuntimeException("Please configure alias in the application.properties");
        }
        if (StringUtils.isBlank(systemConfig.getPrivateKeyAlias())) {
            throw new RuntimeException("Please configure privateKey alias in the application.properties");
        }
        if (StringUtils.isBlank(systemConfig.getPrivateKeyPassword())) {
            throw new RuntimeException("Please configure privateKey password in the application.properties");
        }
        if (StringUtils.isBlank(systemConfig.getKsPassword())) {
            throw new RuntimeException("Please configure keyStore password in the application.properties");
        }
        if (StringUtils.isBlank(systemConfig.getKsPath())) {
            throw new RuntimeException("Please configure keyStore path in the application.properties");
        }
        if (StringUtils.isBlank(systemConfig.getKsFileName())) {
            throw new RuntimeException("Please configure keyStore fileName in the application.properties");
        }
        if (StringUtils.isBlank(systemConfig.getValidTime())) {
            throw new RuntimeException("Please configure validTime in the application.properties");
        }
    }

    private void checkKeyStoreParam(KeyStoreParam keyStoreParam) {
        if (StringUtils.isBlank(keyStoreParam.getCommonName())) {
            throw new RuntimeException("Please set commonName in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getOrganizationUnit())) {
            throw new RuntimeException("Please set organizationUnit in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getCountry())) {
            throw new RuntimeException("Please set country in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getCertAlias())) {
            throw new RuntimeException("Please set certAlias in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getRootAlias())) {
            throw new RuntimeException("Please set rootAlias in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getPrivateKeyAlias())) {
            throw new RuntimeException("Please set privateKeyAlias in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getPrivateKeyPassword())) {
            throw new RuntimeException("Please set privateKey password in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getPath())) {
            throw new RuntimeException("Please set keyStore path in the keyStoreParam");
        }
        if (StringUtils.isBlank(keyStoreParam.getKsPassword())) {
            throw new RuntimeException("Please set keyStore password in the keyStoreParam");
        }
        if (keyStoreParam.getValidTime() <= 0) {
            throw new RuntimeException("Please set cert validTime in the keyStoreParam");
        }
    }

    public static void main(String[] args) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        new RsaCertificate();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        systemConfig = SystemConfig.getInstance();
    }
}

