/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.manage;

import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.cipher.sm.Sm2Util;
import cn.tdchain.tdmsp.ca.config.TdMSPMsg;
import cn.tdchain.tdmsp.manage.Policies;
import cn.tdchain.tdmsp.manage.TdMSPAcl;
import cn.tdchain.tdmsp.util.EccUtil;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;

public class TdMSPIdentity {
    public TdMSPMsg validate(String msg, String signMsg, X509Certificate cert, String method, TdMSPAcl tdMSPAcl, X509Certificate rootCert, String cipherType) {
        TdMSPMsg tdMSPMsg = new TdMSPMsg();
        tdMSPMsg = this.validateCert(rootCert, cert);
        if (tdMSPMsg.getType() != 0) {
            return tdMSPMsg;
        }
        tdMSPMsg = this.verifySignMsg(msg, signMsg, cert, cipherType);
        if (tdMSPMsg.getType() != 0) {
            return tdMSPMsg;
        }
        tdMSPMsg = this.checkCRL(tdMSPAcl, cert);
        if (tdMSPMsg.getType() != 0) {
            return tdMSPMsg;
        }
        String ou = this.getOUFromCert(cert);
        tdMSPMsg = this.checkOU(tdMSPAcl, ou);
        if (tdMSPMsg.getType() != 0) {
            return tdMSPMsg;
        }
        tdMSPMsg = this.checkAcl(tdMSPAcl, method, ou);
        if (tdMSPMsg.getType() != 0) {
            return tdMSPMsg;
        }
        return tdMSPMsg;
    }

    public TdMSPMsg checkAcl(TdMSPAcl tdMSPAcl, String method, String ou) {
        TdMSPMsg tdMSPMsg = new TdMSPMsg();
        tdMSPMsg.setType(3);
        tdMSPMsg.setMessage("No matching organization Unit");
        ArrayList<Policies> aclPolicies = tdMSPAcl.getPoliciesList();
        ArrayList<String> mothodPolicies = this.getPoliciesByMethod(tdMSPAcl, method);
        if (null == mothodPolicies) {
            tdMSPMsg.setType(2);
            tdMSPMsg.setMessage("getPoliciesByMethod is null");
            return tdMSPMsg;
        }
        for (int i = 0; i < mothodPolicies.size(); ++i) {
            String mothodPoliciesName = mothodPolicies.get(i);
            for (int j = 0; j < aclPolicies.size(); ++j) {
                Policies policies = aclPolicies.get(j);
                if (!mothodPoliciesName.equals(policies.getPoliciesName()) || !policies.getPoliciesList().contains(ou)) continue;
                tdMSPMsg.setType(0);
                tdMSPMsg.setMessage("SUCESS");
                return tdMSPMsg;
            }
        }
        return tdMSPMsg;
    }

    public ArrayList<String> getPoliciesByMethod(TdMSPAcl tdMSPAcl, String method) {
        HashMap<String, ArrayList<String>> map = tdMSPAcl.getAclMap();
        if (null == map) {
            return null;
        }
        return map.get(method);
    }

    public TdMSPMsg checkOU(TdMSPAcl tdMSPAcl, String ou) {
        TdMSPMsg tdMSPMsg = new TdMSPMsg();
        if (tdMSPAcl.getOuList().contains(ou)) {
            tdMSPMsg.setType(0);
            tdMSPMsg.setMessage("SUCESS");
        } else {
            tdMSPMsg.setType(1);
            tdMSPMsg.setMessage("The certificate Organization Unit Non-existent ");
        }
        return tdMSPMsg;
    }

    public TdMSPMsg checkOU(TdMSPAcl tdMSPAcl, X509Certificate cert) {
        TdMSPMsg tdMSPMsg = new TdMSPMsg();
        String ou = this.getOUFromCert(cert);
        if (tdMSPAcl.getOuList().contains(ou)) {
            tdMSPMsg.setType(0);
            tdMSPMsg.setMessage("SUCESS");
        } else {
            tdMSPMsg.setType(1);
            tdMSPMsg.setMessage("The certificate Organization Unit Non-existent ");
        }
        return tdMSPMsg;
    }

    public String getOUFromCert(X509Certificate cert) {
        String ou = "";
        String subjectName = cert.getSubjectX500Principal().getName();
        subjectName = subjectName.split("OU=")[1];
        ou = subjectName.substring(0, subjectName.indexOf(","));
        return ou;
    }

    public TdMSPMsg checkCRL(TdMSPAcl tdMSPAcl, X509Certificate cert) {
        TdMSPMsg tdMSPMsg = new TdMSPMsg();
        String serialNumber = cert.getSerialNumber().toString();
        if (tdMSPAcl.getCrlList().contains(serialNumber)) {
            tdMSPMsg.setType(1);
            tdMSPMsg.setMessage("The certificate was revoked");
        } else {
            tdMSPMsg.setType(0);
            tdMSPMsg.setMessage("SUCESS");
        }
        return tdMSPMsg;
    }

    public TdMSPMsg verifySignMsg(String msg, String signMsg, X509Certificate cert, String cipherType) {
        TdMSPMsg tdMSPMsg = new TdMSPMsg();
        boolean verifyRsult = false;
        if ("RSA".equals(cipherType)) {
            try {
                verifyRsult = RsaUtil.verify(cert.getPublicKey(), signMsg, msg);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        } else if ("SM2".equals(cipherType)) {
            verifyRsult = Sm2Util.verify(cert.getPublicKey(), signMsg, msg);
        } else if ("ECC".equals(cipherType)) {
            verifyRsult = EccUtil.verify(msg, signMsg, cert.getPublicKey());
        } else {
            tdMSPMsg.setType(1);
            tdMSPMsg.setMessage("it won't support this cipherType ");
            return tdMSPMsg;
        }
        if (verifyRsult) {
            tdMSPMsg.setType(0);
            tdMSPMsg.setMessage("SUCESS");
        } else {
            tdMSPMsg.setType(1);
            tdMSPMsg.setMessage("verifySignMsg faiure");
        }
        return tdMSPMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TdMSPMsg validateCert(X509Certificate rootCert, X509Certificate cert) {
        TdMSPMsg tdMSPMsg = new TdMSPMsg();
        try {
            cert.verify(rootCert.getPublicKey());
            tdMSPMsg.setType(0);
            tdMSPMsg.setMessage("SUCESS");
        }
        catch (InvalidKeyException e) {
            tdMSPMsg.setType(1);
            tdMSPMsg.setMessage(e.getMessage());
        }
        catch (CertificateException e) {
            tdMSPMsg.setType(2);
            tdMSPMsg.setMessage(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            tdMSPMsg.setType(3);
            tdMSPMsg.setMessage(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            tdMSPMsg.setType(4);
            tdMSPMsg.setMessage(e.getMessage());
        }
        catch (SignatureException e) {
            tdMSPMsg.setType(5);
            tdMSPMsg.setMessage(e.getMessage());
        }
        finally {
            return tdMSPMsg;
        }
    }
}

