/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.net;

import io.netty.channel.Channel;
import org.smartboot.socket.transport.AioSession;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ConnectionCount {

    // connectId--channels(sockets|sessions)
    private final ConcurrentHashMap<String, ArrayList> connectionMap = new ConcurrentHashMap<>();
    // 保证connectid-clientkey一一对应
    private final ConcurrentHashMap<String, OUKey> clientKeyMap = new ConcurrentHashMap<>();
    private static final ConnectionCount connectionCount = new ConnectionCount();

    private ConnectionCount() {
        ScheduledExecutorService exeService = Executors.newSingleThreadScheduledExecutor();
        exeService.scheduleAtFixedRate(() -> {
            try {
                connectionMap.forEach((k, v) -> {
                    Iterator iterator = v.iterator();
                    while (iterator.hasNext()) {
                        Object next = iterator.next();
                        // nio
                        if (next instanceof Channel) {
                            Channel channel = (Channel) next;
                            if (!channel.isActive()) {
                                iterator.remove();
                            }
                        } else if (next instanceof Socket) {
                            Socket socket = (Socket) next;
                            if (socket.isClosed()) {
                                iterator.remove();
                            }
                        } else if (next instanceof AioSession) {
                            AioSession session = (AioSession) next;
                            if (session.isInvalid()) {
                                iterator.remove();
                            }
                        }
                    }
                    if (v.isEmpty()) {
                        connectionMap.remove(k);
                        clientKeyMap.remove(k);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }, 1000, 1000, TimeUnit.MILLISECONDS);
    }

    public static ConnectionCount newInstance() {
        return connectionCount;
    }

    public synchronized void handleConnection(String conId, String ckey, String orgName, Object obj) {
        if (!clientKeyMap.containsKey(conId)) {
            OUKey ouKey = new OUKey();
            ouKey.clientKey = ckey;
            ouKey.ou = orgName;
            clientKeyMap.put(conId, ouKey);
        }
        ArrayList valueList = connectionMap.get(conId);
        if (valueList != null) {
            valueList.add(obj);
        } else {
            valueList = new ArrayList();
            valueList.add(obj);
            connectionMap.put(conId, valueList);
        }
    }

    public synchronized boolean checkSingle(String connid, String clientKey) {
        Set<Map.Entry<String, OUKey>> entries = clientKeyMap.entrySet();
        Iterator<Map.Entry<String, OUKey>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OUKey> next = iterator.next();
            String key = next.getKey();
            OUKey value = next.getValue();
            if (key.equals(connid) && value.clientKey.equals(clientKey)) {
                return true;
            }
            if (key.equals(connid) || value.clientKey.equals(clientKey)) {
                return false;
            }
        }
        return true;
    }

    public String getOUbyPublickey(String ckey) {
        Set<Map.Entry<String, OUKey>> entries = clientKeyMap.entrySet();
        Iterator<Map.Entry<String, OUKey>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OUKey> next = iterator.next();
            OUKey value = next.getValue();
            if (value.clientKey.equals(ckey)) {
                return value.getOu();
            }
        }
        return null;
    }

    public OUKey getOUKey(String connId) {
        if (connId == null) {
            return null;
        }
        return clientKeyMap.get(connId);
    }

    public ConcurrentHashMap<String, OUKey> getClientKeyMap() {
        return clientKeyMap;
    }

    public static class OUKey {
        private String clientKey;
        private String ou;
        private String account;

        public String getAccount() {
            return account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public String getClientKey() {
            return clientKey;
        }

        public void setClientKey(String clientKey) {
            this.clientKey = clientKey;
        }

        public String getOu() {
            return ou;
        }

        public void setOu(String ou) {
            this.ou = ou;
        }
    }
}
