/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.net;

import java.util.List;

import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;

public interface Net {
	/**
	 * Description: 开启网络
	 */
	public void start();
	
	/**
	 * Description: net网络关闭
	 */
	public void stop();
	
	/**
	 * Description: 异步请求
	 * @param msg
	 */
	public void request(RPCMessage msg);
	
	/**
	 * Description: 异步响应，可设置超时时间。
	 * @param messageId
	 * @param timeOut
	 * @return List<RPCResult>
	 */
	public List<RPCResult> resphone(String messageId, long timeOut);
	
	/**
	 * Description: 获取当前net网络中task任务数
	 * @return int
	 */
	public int getTaskSize();
	
	/**
	 * Description: 获取当前net网络中最小的在线节点数
	 * @return int
	 */
	public int getMinNodeSize();
	
	/**
	 * Description: 向net中添加新的Node对象。
	 * @param node
	 */
	public void addNodeToNodes(Node node);

	/**
	 * Description: 获取当前全部节点的node状态
	 * @return List<Node>
	 */
	public List<Node> getNodes();
}
