/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.client;

import cn.tdchain.jbcc.rpc.aio.handler.InHandler;

public abstract class AioAbstractClient {
    protected AioRpcClient aioRpcClient;

    public AioAbstractClient(AioRpcClient aioRpcClient) {
        this.aioRpcClient = aioRpcClient;
    }

    /**
     * Send message.
     * @param msg message
     */
    public void send(String msg) {
        if (msg == null) {
            return;
        }
        this.aioRpcClient.send(msg);


    }

    public boolean isActive() {
        return aioRpcClient.isActive();
    }

    public void close() {
        aioRpcClient.close();
    }

    public InHandler getHandler(Class clazz) {
        return aioRpcClient.getStringClientProcessor().getPipline().getHandler(clazz);
    }
}

